/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.ant.task.configuration;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.TaskConfigConstants;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskRequirementSupport;
import com.atlassian.bamboo.task.TaskTestResultsSupport;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.v2.build.agent.capability.Requirement;
import com.atlassian.bamboo.ww2.actions.build.admin.create.UIConfigSupport;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.opensymphony.xwork2.TextProvider;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AntBuildTaskConfigurator
extends AbstractTaskConfigurator
implements TaskRequirementSupport,
TaskTestResultsSupport {
    private static final Logger log = Logger.getLogger(AntBuildTaskConfigurator.class);
    private static final String CTX_UI_CONFIG_SUPPORT = "uiConfigSupport";
    private static final List<String> FIELDS_TO_COPY = ImmutableList.of((Object)"buildFile", (Object)"target");
    private static final String DEFAULT_TARGET = "clean test";
    private static final String DEFAULT_TEST_RESULTS_PATTERN = "**/test-reports/*.xml";
    private TextProvider textProvider;
    private UIConfigSupport uiConfigSupport;

    @NotNull
    public Set<Requirement> calculateRequirements(@NotNull TaskDefinition taskDefinition) {
        HashSet requirements = Sets.newHashSet();
        this.taskConfiguratorHelper.addJdkRequirement((Set)requirements, taskDefinition, "buildJdk");
        this.taskConfiguratorHelper.addSystemRequirementFromConfiguration((Set)requirements, taskDefinition, "label", "system.builder.ant");
        return requirements;
    }

    public void populateContextForView(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForView(context, taskDefinition);
        this.taskConfiguratorHelper.populateContextWithConfiguration(context, taskDefinition, Iterables.concat((Iterable)TaskConfigConstants.DEFAULT_BUILDER_CONFIGURATION_KEYS, FIELDS_TO_COPY));
        context.put("hasTests", Boolean.valueOf((String)taskDefinition.getConfiguration().get("testChecked")));
        context.put(CTX_UI_CONFIG_SUPPORT, this.uiConfigSupport);
    }

    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        this.taskConfiguratorHelper.populateContextWithConfiguration(context, taskDefinition, Iterables.concat((Iterable)TaskConfigConstants.DEFAULT_BUILDER_CONFIGURATION_KEYS, FIELDS_TO_COPY));
        context.put("hasTests", Boolean.valueOf((String)taskDefinition.getConfiguration().get("testChecked")));
        context.put(CTX_UI_CONFIG_SUPPORT, this.uiConfigSupport);
    }

    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        context.put("target", DEFAULT_TARGET);
        context.put("testResultsDirectory", DEFAULT_TEST_RESULTS_PATTERN);
        context.put("hasTests", Boolean.TRUE);
        context.put("testChecked", Boolean.TRUE);
        context.put(CTX_UI_CONFIG_SUPPORT, this.uiConfigSupport);
        context.put("buildJdk", this.uiConfigSupport.getDefaultJdkLabel());
    }

    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        this.taskConfiguratorHelper.validateBuilderLabel(params, errorCollection);
        this.taskConfiguratorHelper.validateJdk(params, errorCollection);
        this.taskConfiguratorHelper.validateTestResultsFilePattern(params, errorCollection);
        if (StringUtils.isEmpty((String)params.getString("target"))) {
            errorCollection.addError("target", this.textProvider.getText("task.ant.validate.goals.mandatory"));
        }
    }

    @NotNull
    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map config = super.generateTaskConfigMap(params, previousTaskDefinition);
        this.taskConfiguratorHelper.populateTaskConfigMapWithActionParameters(config, params, Iterables.concat((Iterable)TaskConfigConstants.DEFAULT_BUILDER_CONFIGURATION_KEYS, FIELDS_TO_COPY));
        return config;
    }

    public boolean taskProducesTestResults(@NotNull TaskDefinition taskDefinition) {
        return Boolean.parseBoolean((String)taskDefinition.getConfiguration().get("testChecked"));
    }

    public void setTextProvider(TextProvider textProvider) {
        this.textProvider = textProvider;
    }

    public void setUiConfigSupport(UIConfigSupport uiConfigSupport) {
        this.uiConfigSupport = uiConfigSupport;
    }
}

