/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.ant.task;

import com.atlassian.bamboo.process.CommandlineStringUtils;
import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class AntConfig {
    private static final Logger log = Logger.getLogger(AntConfig.class);
    public static final String CFG_BUILD_FILE = "buildFile";
    public static final String CFG_BUILDER_LABEL = "label";
    protected static final String CFG_ENVIRONMENT_VARIABLES = "environmentVariables";
    protected static final String CFG_HAS_TESTS = "testChecked";
    public static final String CFG_JDK_LABEL = "buildJdk";
    public static final String CFG_TARGETS = "target";
    protected static final String CFG_TEST_RESULTS_FILE_PATTERN = "testResultsDirectory";
    public static final String ANT_CAPABILITY_PREFIX = "system.builder.ant";
    protected static final String ANT_EXECUTABLE_NAME_UNIX = "ant";
    protected static final String ANT_EXECUTABLE_NAME_WINDOWS = "ant.bat";
    protected final String builderLabel;
    protected final String builderPath;
    protected final String buildFile;
    protected final String environmentVariables;
    protected final boolean hasTests;
    protected final String jdkLabel;
    protected final List<String> targets;
    protected final String testResultsFilePattern;
    protected final File workingDirectory;
    protected final Map<String, String> extraEnvironment = Maps.newHashMap();

    public AntConfig(@NotNull CommonTaskContext taskContext, @NotNull CapabilityContext capabilityContext, @NotNull EnvironmentVariableAccessor environmentVariableAccessor) {
        this.buildFile = (String)taskContext.getConfigurationMap().get((Object)CFG_BUILD_FILE);
        this.targets = CommandlineStringUtils.tokeniseCommandline((String)StringUtils.replaceChars((String)((String)taskContext.getConfigurationMap().get((Object)CFG_TARGETS)), (String)"\r\n", (String)"  "));
        this.builderLabel = (String)Preconditions.checkNotNull((Object)taskContext.getConfigurationMap().get((Object)CFG_BUILDER_LABEL), (Object)"Builder label is not defined");
        this.builderPath = (String)Preconditions.checkNotNull((Object)capabilityContext.getCapabilityValue("system.builder.ant." + this.builderLabel), (Object)"Builder path is not defined");
        this.environmentVariables = (String)taskContext.getConfigurationMap().get((Object)CFG_ENVIRONMENT_VARIABLES);
        this.hasTests = taskContext.getConfigurationMap().getAsBoolean(CFG_HAS_TESTS);
        this.jdkLabel = (String)taskContext.getConfigurationMap().get((Object)CFG_JDK_LABEL);
        this.testResultsFilePattern = (String)taskContext.getConfigurationMap().get((Object)CFG_TEST_RESULTS_FILE_PATTERN);
        this.workingDirectory = taskContext.getWorkingDirectory();
        this.extraEnvironment.putAll(environmentVariableAccessor.splitEnvironmentAssignments(this.environmentVariables, false));
        this.extraEnvironment.put("ANT_HOME", this.builderPath);
    }

    @NotNull
    protected String getAntExecutableName() {
        return SystemUtils.IS_OS_WINDOWS ? ANT_EXECUTABLE_NAME_WINDOWS : ANT_EXECUTABLE_NAME_UNIX;
    }

    protected String getAntExecutablePath(String homePath) {
        String pathToExecutable = StringUtils.join((Object[])new String[]{homePath, "bin", this.getAntExecutableName()}, (String)File.separator);
        if (StringUtils.contains((String)pathToExecutable, (String)" ")) {
            try {
                File f = new File(pathToExecutable);
                pathToExecutable = f.getCanonicalPath();
            }
            catch (IOException e) {
                log.warn((Object)"IO Exception trying to get executable", (Throwable)e);
            }
        }
        return pathToExecutable;
    }

    public String getFirstTarget() {
        return this.targets.iterator().next();
    }

    public List<String> getCommandline() {
        ArrayList arguments = Lists.newArrayList();
        arguments.add(this.getAntExecutablePath(this.builderPath));
        if (StringUtils.isNotEmpty((String)this.buildFile)) {
            arguments.addAll(Arrays.asList("-f", this.buildFile));
        }
        arguments.addAll(this.targets);
        return arguments;
    }

    public Map<String, String> getExtraEnvironment() {
        return this.extraEnvironment;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public boolean isHasTests() {
        return this.hasTests;
    }

    public String getTestResultsFilePattern() {
        return this.testResultsFilePattern;
    }
}

