/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.ant.task;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.logger.LogInterceptor;
import com.atlassian.bamboo.build.logger.interceptors.ContentMatchingInterceptor;
import com.atlassian.bamboo.build.logger.interceptors.ErrorMemorisingInterceptor;
import com.atlassian.bamboo.build.logger.interceptors.StringMatchingInterceptor;
import com.atlassian.bamboo.build.test.TestCollationService;
import com.atlassian.bamboo.plugins.ant.task.AntConfig;
import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.process.ExternalProcessBuilder;
import com.atlassian.bamboo.process.ProcessService;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.CommonTaskType;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.v2.build.CurrentResult;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.utils.process.ExternalProcess;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class AntBuildTask
implements CommonTaskType {
    private static final Logger log = Logger.getLogger(AntBuildTask.class);
    private static final String BUILD_SUCCESSFUL_MARKER = SystemProperty.BUILD_SUCCESSFUL_MARKER.getValue("BUILD SUCCESS");
    private static final String BUILD_FAILED_MARKER = SystemProperty.BUILD_FAILED_MARKER.getValue("BUILD FAILED");
    private static final boolean SEARCH_BUILD_SUCCESS_FAIL_MESSAGE_EVERYWHERE = SystemProperty.SEARCH_BUILD_SUCCESS_FAIL_MESSAGE_EVERYWHERE.getValue(false);
    private static final int FIND_SUCCESS_MESSAGE_IN_LAST;
    private static final int FIND_FAILURE_MESSAGE_IN_LAST;
    private final CapabilityContext capabilityContext;
    private final EnvironmentVariableAccessor environmentVariableAccessor;
    private final ProcessService processService;
    private final TestCollationService testCollationService;

    public AntBuildTask(CapabilityContext capabilityContext, EnvironmentVariableAccessor environmentVariableAccessor, ProcessService processService, TestCollationService testCollationService) {
        this.capabilityContext = capabilityContext;
        this.environmentVariableAccessor = environmentVariableAccessor;
        this.processService = processService;
        this.testCollationService = testCollationService;
    }

    @NotNull
    public TaskResult execute(@NotNull CommonTaskContext taskContext) throws TaskException {
        BuildLogger buildLogger = taskContext.getBuildLogger();
        CurrentResult currentResult = taskContext.getCommonContext().getCurrentResult();
        AntConfig config = new AntConfig(taskContext, this.capabilityContext, this.environmentVariableAccessor);
        StringMatchingInterceptor buildSuccessMatcher = new StringMatchingInterceptor(BUILD_SUCCESSFUL_MARKER, SEARCH_BUILD_SUCCESS_FAIL_MESSAGE_EVERYWHERE);
        StringMatchingInterceptor buildFailureMatcher = new StringMatchingInterceptor(BUILD_FAILED_MARKER, SEARCH_BUILD_SUCCESS_FAIL_MESSAGE_EVERYWHERE);
        ErrorMemorisingInterceptor errorLines = ErrorMemorisingInterceptor.newInterceptor();
        buildLogger.getInterceptorStack().add((LogInterceptor)buildSuccessMatcher);
        buildLogger.getInterceptorStack().add((LogInterceptor)buildFailureMatcher);
        buildLogger.getInterceptorStack().add((LogInterceptor)errorLines);
        try {
            ExternalProcess externalProcess = this.processService.executeExternalProcess(taskContext, new ExternalProcessBuilder().workingDirectory(config.getWorkingDirectory()).env(config.getExtraEnvironment()).command(config.getCommandline()));
            if (externalProcess.getHandler().isComplete()) {
                TaskResultBuilder taskResultBuilder = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).checkReturnCode(externalProcess).checkInterceptorNotMatches((ContentMatchingInterceptor)buildFailureMatcher, FIND_FAILURE_MESSAGE_IN_LAST).checkInterceptorMatches((ContentMatchingInterceptor)buildSuccessMatcher, FIND_SUCCESS_MESSAGE_IN_LAST);
                if (taskContext instanceof TaskContext && config.isHasTests() && config.getTestResultsFilePattern() != null) {
                    this.testCollationService.collateTestResults((TaskContext)taskContext, config.getTestResultsFilePattern());
                    taskResultBuilder.checkTestFailures();
                }
                TaskResult taskResult = taskResultBuilder.build();
                return taskResult;
            }
            try {
                throw new TaskException("Failed to execute command, external process not completed?");
            }
            catch (Throwable e) {
                throw new TaskException("Failed to execute task", e);
            }
        }
        finally {
            currentResult.addBuildErrors(errorLines.getErrorStringList());
        }
    }

    static {
        FIND_FAILURE_MESSAGE_IN_LAST = FIND_SUCCESS_MESSAGE_IN_LAST = SystemProperty.FIND_SUCCESS_MESSAGE_IN_LAST.getValue(250);
    }
}

