/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.ant.decorator;

import com.atlassian.bamboo.plugins.ant.utils.AntHelper;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.plugins.TaskProcessCommandDecorator;
import com.atlassian.bamboo.utils.SystemProperty;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class IsolatedTmpDirCommandDecorator
implements TaskProcessCommandDecorator {
    private static final Logger log = Logger.getLogger(IsolatedTmpDirCommandDecorator.class);
    private static final String JAVA_IO_TMPDIR_PROPERTY = "java.io.tmpdir";

    @NotNull
    public List<String> decorate(@NotNull TaskContext taskContext, @NotNull List<String> command) {
        ArrayList decoratedCommand = Lists.newArrayList(command);
        File isolatedTmpDir = new File(SystemProperty.BUILD_PARENT_JAVA_IO_TMPDIR.getValue(), taskContext.getBuildContext().getPlanKey());
        if (isolatedTmpDir.exists() || isolatedTmpDir.mkdirs()) {
            AntHelper.addPropertyToCommand(decoratedCommand, JAVA_IO_TMPDIR_PROPERTY, isolatedTmpDir.getAbsolutePath());
        }
        return decoratedCommand;
    }
}

