/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.util;

import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;

public final class FileUtils {
    private FileUtils() {
    }

    public static String readFileContent(@NotNull Path path, String fileIsNullErrorMessage, String fileReadErrorMessage) {
        ImporterUtils.checkNotNull((String)fileIsNullErrorMessage, (Object)path);
        if (Files.notExists(path, new LinkOption[0])) {
            throw new PropertiesValidationException(String.format("File %s does not exist", path.toAbsolutePath()));
        }
        try {
            return FileUtils.readFileToString(path);
        }
        catch (IOException e) {
            throw new PropertiesValidationException(String.format(fileReadErrorMessage, path.toAbsolutePath()), (Throwable)e);
        }
    }

    public static String readFileToString(Path path) throws IOException {
        return new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
    }
}

