/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.model.task;

import com.atlassian.bamboo.specs.api.codegen.annotations.CodeGenerator;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import com.atlassian.bamboo.specs.api.model.repository.VcsRepositoryIdentifierProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.codegen.emitters.task.CheckoutSpecEmitter;
import java.util.Objects;

@CodeGenerator(value=CheckoutSpecEmitter.class)
public class CheckoutItemProperties
implements EntityProperties {
    private final VcsRepositoryIdentifierProperties repository;
    private final boolean defaultRepository;
    private final String path;

    private CheckoutItemProperties() {
        this.repository = null;
        this.defaultRepository = false;
        this.path = "";
    }

    public CheckoutItemProperties(VcsRepositoryIdentifierProperties repository, String path, boolean defaultRepository) {
        this.repository = repository;
        this.defaultRepository = defaultRepository;
        this.path = path;
        this.validate();
    }

    public static CheckoutItemProperties forDefaultRepository() {
        return new CheckoutItemProperties(null, "", true);
    }

    public boolean isDefaultRepository() {
        return this.defaultRepository;
    }

    public VcsRepositoryIdentifierProperties getRepository() {
        return this.repository;
    }

    public String getPath() {
        return this.path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckoutItemProperties that = (CheckoutItemProperties)o;
        return this.isDefaultRepository() == that.isDefaultRepository() && Objects.equals(this.getRepository(), that.getRepository()) && Objects.equals(this.getPath(), that.getPath());
    }

    public int hashCode() {
        return Objects.hash(this.getRepository(), this.isDefaultRepository(), this.getPath());
    }

    public void validate() {
        ValidationContext context = ValidationContext.of((String)"VCS checkout task").with("Checkout spec");
        if (!this.defaultRepository) {
            ImporterUtils.checkRequired((ValidationContext)context.with("repository"), (Object)this.repository);
        }
        ImporterUtils.checkRequired((ValidationContext)context.with("path"), (Object)this.path);
    }
}

