/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.codegen.emitters.plan.branches;

import com.atlassian.bamboo.specs.api.builders.plan.branches.BranchCleanup;
import com.atlassian.bamboo.specs.api.codegen.CodeGenerationContext;
import com.atlassian.bamboo.specs.api.codegen.CodeGenerationException;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import com.atlassian.bamboo.specs.api.model.plan.branches.BranchCleanupProperties;
import com.atlassian.bamboo.specs.codegen.emitters.value.EntityPropertiesEmitter;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class BranchCleanupEmitter
extends EntityPropertiesEmitter<BranchCleanupProperties> {
    @Override
    @NotNull
    public String emitCode(@NotNull CodeGenerationContext context, @NotNull BranchCleanupProperties entity) throws CodeGenerationException {
        String otherFields;
        this.builderClass = BranchCleanup.class;
        this.fieldsToSkip.add("removeDeletedFromRepository");
        this.fieldsToSkip.add("removeInactiveInRepository");
        this.fieldsToSkip.add("removeDeletedFromRepositoryPeriod");
        this.fieldsToSkip.add("removeInactiveInRepositoryPeriod");
        StringBuilder builder = new StringBuilder();
        builder.append(this.emitConstructorInvocation(context, entity));
        if (entity.isRemoveDeletedFromRepository()) {
            builder.append(context.newLine());
            long removedAfterDays = entity.getRemoveDeletedFromRepositoryPeriod().toDays();
            builder.append(".whenRemovedFromRepositoryAfterDays(").append(removedAfterDays).append(")");
        }
        if (entity.isRemoveInactiveInRepository()) {
            builder.append(context.newLine());
            long inactiveAfterDays = entity.getRemoveInactiveInRepositoryPeriod().toDays();
            builder.append(".whenInactiveInRepositoryAfterDays(").append(inactiveAfterDays).append(")");
        }
        if (StringUtils.isNotBlank((CharSequence)(otherFields = this.emitFields(context, (EntityProperties)entity)))) {
            builder.append(context.newLine());
            builder.append(otherFields);
        }
        return builder.toString();
    }
}

