/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.util;

import com.atlassian.bamboo.specs.util.Logger;
import com.atlassian.bamboo.specs.util.UserPasswordCredentials;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class SimpleUserPasswordCredentials
implements UserPasswordCredentials {
    private static final Logger log = Logger.getLogger(SimpleUserPasswordCredentials.class);
    private final String username;
    private final String password;

    public SimpleUserPasswordCredentials(@NotNull String username, @NotNull String password) {
        this.username = this.checkField("Username", username);
        this.password = this.checkField("Password", password);
    }

    private String checkField(String fieldName, String fieldValue) {
        if (StringUtils.isEmpty((CharSequence)fieldValue)) {
            log.info("%s must be specified to access Bamboo", fieldName);
            throw new IllegalArgumentException(fieldName + " was not defined");
        }
        return fieldValue;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public String toString() {
        return String.format("[type: 'simple', username: '%s']", this.username);
    }
}

