/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.model.task;

import com.atlassian.bamboo.specs.api.model.plan.condition.ConditionProperties;
import com.atlassian.bamboo.specs.api.model.plan.requirement.RequirementProperties;
import com.atlassian.bamboo.specs.api.model.repository.VcsRepositoryIdentifierProperties;
import com.atlassian.bamboo.specs.api.model.task.TaskProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseVcsTaskProperties
extends TaskProperties {
    private final boolean defaultRepository;
    @Nullable
    private final VcsRepositoryIdentifierProperties repository;
    @Nullable
    private final String workingSubdirectory;

    protected BaseVcsTaskProperties() {
        this.defaultRepository = false;
        this.repository = null;
        this.workingSubdirectory = null;
    }

    protected BaseVcsTaskProperties(@Nullable String description, boolean enabled, @NotNull List<RequirementProperties> requirements, @NotNull List<? extends ConditionProperties> conditions, boolean defaultRepository, @Nullable VcsRepositoryIdentifierProperties repository, @Nullable String workingSubdirectory) {
        super(description, enabled, requirements, conditions);
        this.defaultRepository = defaultRepository;
        this.repository = repository;
        this.workingSubdirectory = workingSubdirectory;
    }

    @NotNull
    protected abstract ValidationContext getValidationContext();

    public void validate() {
        super.validate();
        if (!this.defaultRepository) {
            ImporterUtils.checkRequired((ValidationContext)this.getValidationContext().with("repository"), (Object)this.repository);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BaseVcsTaskProperties)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BaseVcsTaskProperties that = (BaseVcsTaskProperties)((Object)o);
        return this.isDefaultRepository() == that.isDefaultRepository() && Objects.equals(this.getRepository(), that.getRepository()) && Objects.equals(this.getWorkingSubdirectory(), that.getWorkingSubdirectory());
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.isDefaultRepository(), this.getRepository(), this.getWorkingSubdirectory());
    }

    public boolean isDefaultRepository() {
        return this.defaultRepository;
    }

    @Nullable
    public VcsRepositoryIdentifierProperties getRepository() {
        return this.repository;
    }

    @Nullable
    public String getWorkingSubdirectory() {
        return this.workingSubdirectory;
    }
}

