/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.codegen.emitters.task;

import com.atlassian.bamboo.specs.api.codegen.CodeGenerationContext;
import com.atlassian.bamboo.specs.api.codegen.CodeGenerationException;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import com.atlassian.bamboo.specs.builders.task.ScpTask;
import com.atlassian.bamboo.specs.codegen.emitters.task.ArtifactItemEmitter;
import com.atlassian.bamboo.specs.codegen.emitters.task.BaseSshTaskAuthenticationEmitter;
import com.atlassian.bamboo.specs.codegen.emitters.value.EntityPropertiesEmitter;
import com.atlassian.bamboo.specs.model.task.ArtifactItemProperties;
import com.atlassian.bamboo.specs.model.task.ScpTaskProperties;
import org.jetbrains.annotations.NotNull;

public class ScpTaskEmitter
extends EntityPropertiesEmitter<ScpTaskProperties> {
    @Override
    @NotNull
    public String emitCode(@NotNull CodeGenerationContext context, @NotNull ScpTaskProperties entity) throws CodeGenerationException {
        this.builderClass = ScpTask.class;
        this.fieldsToSkip.add("artifactItem");
        this.fieldsToSkip.add("localPath");
        this.fieldsToSkip.add("localPathAntStyle");
        return this.emitConstructorInvocation(context, entity) + this.emitFields(context, (EntityProperties)entity) + context.incIndentation() + context.newLine() + new BaseSshTaskAuthenticationEmitter().emitCodeForAuthentication(entity, context) + context.newLine() + this.emitCodeForLocalPathOrArtifact(context, entity) + context.decIndentation();
    }

    private String emitCodeForLocalPathOrArtifact(@NotNull CodeGenerationContext context, @NotNull ScpTaskProperties entity) throws CodeGenerationException {
        if (entity.getLocalPath() != null) {
            return this.emitCodeForLocalPath(entity);
        }
        if (entity.getArtifactItem() != null) {
            return this.emitCodeForArtifact(context, entity);
        }
        throw new CodeGenerationException("ScpTask requires an artifact to be uploaded. Neither a local file/directory nor a downloaded artifact was found in the task configuration.");
    }

    private String emitCodeForLocalPath(@NotNull ScpTaskProperties entity) {
        return String.format(".fromLocalPath(\"%s\", %b)", entity.getLocalPath(), entity.isLocalPathAntStyle());
    }

    private String emitCodeForArtifact(@NotNull CodeGenerationContext context, @NotNull ScpTaskProperties entity) throws CodeGenerationException {
        ArtifactItemProperties aip = entity.getArtifactItem();
        if (aip == null) {
            throw new CodeGenerationException("Artifact property is null");
        }
        return String.format(".fromArtifact(%s)", new ArtifactItemEmitter().emitCode(context, aip));
    }
}

