/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.builders.trigger;

import com.atlassian.bamboo.specs.api.builders.trigger.RepositoryBasedTrigger;
import com.atlassian.bamboo.specs.api.model.repository.VcsRepositoryIdentifierProperties;
import com.atlassian.bamboo.specs.api.util.CronExpressionCreationHelper;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.model.trigger.RepositoryPollingTriggerProperties;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.LocalTime;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class RepositoryPollingTrigger
extends RepositoryBasedTrigger<RepositoryPollingTrigger, RepositoryPollingTriggerProperties> {
    private static final EnumSet<TimeUnit> APPLICABLE_TIME_UNITS = EnumSet.of(TimeUnit.SECONDS, TimeUnit.MINUTES, TimeUnit.HOURS, TimeUnit.DAYS);
    private RepositoryPollingTriggerProperties.PollType pollType;
    private Duration pollingPeriod;
    private String cronExpression;

    public RepositoryPollingTrigger() {
        this.triggeringRepositoriesType = RepositoryBasedTrigger.TriggeringRepositoriesType.ALL;
        this.pollingPeriod = Duration.ofSeconds(180L);
        this.cronExpression = null;
        this.pollType = RepositoryPollingTriggerProperties.PollType.PERIOD;
    }

    public RepositoryPollingTrigger pollEvery(int every, @NotNull TimeUnit timeUnit) {
        ImporterUtils.checkNotNull((String)"timeUnit", (Object)((Object)timeUnit));
        ImporterUtils.checkPositive((String)"pollingPeriod", (int)every);
        ImporterUtils.checkArgument((ValidationContext)ValidationContext.empty(), (boolean)APPLICABLE_TIME_UNITS.contains((Object)timeUnit), (Object)"Polling is available only with seconds, minutes and hours based period");
        this.pollingPeriod = Duration.ofSeconds(timeUnit.toSeconds(every));
        this.pollType = RepositoryPollingTriggerProperties.PollType.PERIOD;
        this.cronExpression = null;
        return this;
    }

    public RepositoryPollingTrigger withPollingPeriod(@NotNull Duration duration) {
        ImporterUtils.checkNotNull((String)"duration", (Object)duration);
        ImporterUtils.checkArgument((ValidationContext)ValidationContext.empty(), (duration.getSeconds() > 0L ? 1 : 0) != 0, (Object)"Polling interval cannot be shorted than one second");
        this.pollingPeriod = duration;
        this.pollType = RepositoryPollingTriggerProperties.PollType.PERIOD;
        this.cronExpression = null;
        return this;
    }

    public RepositoryPollingTrigger withPollType(@NotNull RepositoryPollingTriggerProperties.PollType pollType) {
        ImporterUtils.checkNotNull((String)"pollType", (Object)((Object)pollType));
        this.pollType = pollType;
        return this;
    }

    public RepositoryPollingTrigger pollOnceDaily(@NotNull LocalTime at) {
        return this.pollWithCronExpression(CronExpressionCreationHelper.scheduleOnceDaily((LocalTime)at));
    }

    public RepositoryPollingTrigger pollWeekly(@NotNull LocalTime at, DayOfWeek ... onDays) {
        return this.pollWithCronExpression(CronExpressionCreationHelper.scheduleWeekly((LocalTime)at, (DayOfWeek[])onDays));
    }

    public RepositoryPollingTrigger pollWeekly(@NotNull LocalTime at, @NotNull Collection<DayOfWeek> days) {
        return this.pollWithCronExpression(CronExpressionCreationHelper.scheduleWeekly((LocalTime)at, days));
    }

    public RepositoryPollingTrigger pollMonthly(@NotNull LocalTime at, int dayOfMonth) {
        return this.pollWithCronExpression(CronExpressionCreationHelper.scheduleMonthly((LocalTime)at, (int)dayOfMonth));
    }

    public RepositoryPollingTrigger pollWithCronExpression(@NotNull String cronExpression) {
        ImporterUtils.checkNotBlank((String)"cronExpression", (String)cronExpression);
        this.cronExpression = cronExpression;
        this.pollType = RepositoryPollingTriggerProperties.PollType.CRON;
        this.pollingPeriod = null;
        return this;
    }

    protected RepositoryPollingTriggerProperties build() {
        switch (this.pollType) {
            case PERIOD: {
                return new RepositoryPollingTriggerProperties(this.description, this.triggerEnabled, this.triggeringRepositoriesType, (List<VcsRepositoryIdentifierProperties>)this.selectedTriggeringRepositories, this.pollingPeriod);
            }
            case CRON: {
                return new RepositoryPollingTriggerProperties(this.description, this.triggerEnabled, this.triggeringRepositoriesType, (List<VcsRepositoryIdentifierProperties>)this.selectedTriggeringRepositories, this.cronExpression);
            }
        }
        throw new AssertionError((Object)String.format("Don't know what %s is.", new Object[]{this.pollType}));
    }
}

