/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.model.plan.requirement;

import com.atlassian.bamboo.specs.api.builders.requirement.Requirement;
import com.atlassian.bamboo.specs.api.codegen.annotations.Builder;
import com.atlassian.bamboo.specs.api.codegen.annotations.ConstructFrom;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.concurrent.Immutable;

@Builder(value=Requirement.class)
@ConstructFrom(value={"key"})
@Immutable
public class RequirementProperties
implements EntityProperties {
    private final String key;
    private final String matchValue;
    private final Requirement.MatchType matchType;

    private RequirementProperties() {
        this.matchType = Requirement.MatchType.EXISTS;
        this.matchValue = ".*";
        this.key = null;
    }

    public RequirementProperties(String key, String matchValue, Requirement.MatchType matchType) {
        this.key = key;
        this.matchValue = matchValue;
        this.matchType = matchType;
        this.validate();
    }

    public String getKey() {
        return this.key;
    }

    public String getMatchValue() {
        return this.matchValue;
    }

    public Requirement.MatchType getMatchType() {
        return this.matchType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequirementProperties that = (RequirementProperties)o;
        return Objects.equals(this.getKey(), that.getKey()) && Objects.equals(this.getMatchValue(), that.getMatchValue()) && this.getMatchType() == that.getMatchType();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getKey(), this.getMatchValue(), this.getMatchType()});
    }

    @Override
    public void validate() throws PropertiesValidationException {
        ImporterUtils.checkNotBlank("key", this.key);
        ImporterUtils.checkNotNull("matchType", this.matchType);
        if (this.matchType != Requirement.MatchType.EXISTS) {
            ImporterUtils.checkNotBlank("matchValue", this.matchValue);
        }
        if (this.matchType == Requirement.MatchType.MATCHES) {
            try {
                Pattern.compile(this.matchValue);
            }
            catch (PatternSyntaxException e) {
                throw new PropertiesValidationException("Branch name pattern is not correct regex: " + e.getMessage());
            }
        }
    }
}

