/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.model.permission;

import com.atlassian.bamboo.specs.api.codegen.annotations.ConstructFrom;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.BambooOidProperties;
import com.atlassian.bamboo.specs.api.model.RootEntityProperties;
import com.atlassian.bamboo.specs.api.model.permission.PermissionsProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.permission.PermissionValidator;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.jetbrains.annotations.NotNull;

@ConstructFrom(value={"deploymentName"})
@Immutable
public class DeploymentPermissionsProperties
implements RootEntityProperties {
    private final BambooOidProperties deploymentOid;
    private final String deploymentName;
    private final PermissionsProperties permissions;

    private DeploymentPermissionsProperties() {
        this.deploymentOid = null;
        this.deploymentName = null;
        this.permissions = null;
    }

    public DeploymentPermissionsProperties(@NotNull String deploymentName, @NotNull PermissionsProperties permissions) throws PropertiesValidationException {
        this.deploymentOid = null;
        this.deploymentName = deploymentName;
        this.permissions = permissions;
        this.validate();
    }

    public DeploymentPermissionsProperties(@NotNull BambooOidProperties deploymentOid, @NotNull PermissionsProperties permissions) throws PropertiesValidationException {
        this.deploymentOid = deploymentOid;
        this.deploymentName = null;
        this.permissions = permissions;
        this.validate();
    }

    @Override
    public void validate() throws PropertiesValidationException {
        if (this.deploymentName == null && this.deploymentOid == null) {
            throw new PropertiesValidationException("deployment oid or name should be not null");
        }
        ImporterUtils.checkNotNull("permissions", this.permissions);
        ImporterUtils.checkNoErrors(PermissionValidator.validatePermissions(this.permissions, PermissionValidator.PermissionTarget.DEPLOYMENT));
    }

    public BambooOidProperties getDeploymentOid() {
        return this.deploymentOid;
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public PermissionsProperties getPermissions() {
        return this.permissions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeploymentPermissionsProperties that = (DeploymentPermissionsProperties)o;
        return Objects.equals(this.deploymentOid, that.deploymentOid) && Objects.equals(this.deploymentName, that.deploymentName) && Objects.equals(this.permissions, that.permissions);
    }

    public int hashCode() {
        return Objects.hash(this.deploymentOid, this.deploymentName, this.permissions);
    }

    @Override
    @NotNull
    public String humanReadableType() {
        return "deployment permission";
    }

    @Override
    public String humanReadableId() {
        StringBuilder id = new StringBuilder();
        id.append("deployment permission");
        id.append(" for deployment ");
        if (this.deploymentOid != null) {
            id.append(this.deploymentOid);
        } else {
            id.append(this.deploymentName);
        }
        return id.toString();
    }
}

