/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.model.docker;

import com.atlassian.bamboo.specs.api.codegen.annotations.CodeGeneratorName;
import com.atlassian.bamboo.specs.api.codegen.annotations.DefaultFieldValues;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.StringUtils;

@Immutable
public class DockerConfigurationProperties
implements EntityProperties {
    public static final ValidationContext VALIDATION_CONTEXT = ValidationContext.of("Docker configuration");
    public static final Map<String, String> DEFAULT_VOLUMES;
    private final boolean enabled;
    private final String image;
    @CodeGeneratorName(value="com.atlassian.bamboo.specs.codegen.emitters.docker.DockerConfigurationVolumesEmitter")
    private final Map<String, String> volumes;
    private final List<String> dockerRunArguments;

    private DockerConfigurationProperties() {
        this(false, Collections.emptyMap(), Collections.emptyList());
    }

    private DockerConfigurationProperties(boolean enabled, Map<String, String> volumes, List<String> dockerRunArguments) {
        this.enabled = enabled;
        this.image = null;
        this.volumes = volumes;
        this.dockerRunArguments = dockerRunArguments;
    }

    public DockerConfigurationProperties(boolean enabled, String image, Map<String, String> volumes, List<String> dockerRunArguments) {
        this.enabled = enabled;
        this.image = image;
        this.volumes = volumes != null ? Collections.unmodifiableMap(new LinkedHashMap<String, String>(volumes)) : Collections.emptyMap();
        this.dockerRunArguments = dockerRunArguments != null ? Collections.unmodifiableList(new ArrayList<String>(dockerRunArguments)) : Collections.emptyList();
        this.validate();
    }

    @DefaultFieldValues
    private static DockerConfigurationProperties defaults() {
        return new DockerConfigurationProperties(true, DEFAULT_VOLUMES, Collections.emptyList());
    }

    @Override
    public void validate() {
        if (this.enabled) {
            ImporterUtils.checkNotBlank(VALIDATION_CONTEXT, "image", this.image);
            HashSet occupiedContainerVolumes = new HashSet();
            this.volumes.forEach((key, value) -> {
                ImporterUtils.checkNotBlank(VALIDATION_CONTEXT, "volume container directory", StringUtils.trimToNull((String)value));
                ImporterUtils.checkNotBlank(VALIDATION_CONTEXT, "volume host directory", StringUtils.trimToNull((String)key));
                if (!occupiedContainerVolumes.add(value)) {
                    throw new PropertiesValidationException(VALIDATION_CONTEXT, "Volume " + value + " is already defined.");
                }
            });
            this.dockerRunArguments.forEach(arg -> ImporterUtils.checkNotBlank(VALIDATION_CONTEXT, "argument", arg));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DockerConfigurationProperties)) {
            return false;
        }
        DockerConfigurationProperties that = (DockerConfigurationProperties)o;
        return this.enabled == that.enabled && Objects.equals(this.image, that.image) && Objects.equals(this.volumes, that.volumes) && Objects.equals(this.dockerRunArguments, that.dockerRunArguments);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.image, this.volumes, this.dockerRunArguments);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getImage() {
        return this.image;
    }

    public Map<String, String> getVolumes() {
        return this.volumes;
    }

    public List<String> getDockerRunArguments() {
        return this.dockerRunArguments;
    }

    static {
        LinkedHashMap<String, String> defaultVolumes = new LinkedHashMap<String, String>();
        defaultVolumes.put("${bamboo.working.directory}", "${bamboo.working.directory}");
        defaultVolumes.put("${bamboo.tmp.directory}", "${bamboo.tmp.directory}");
        DEFAULT_VOLUMES = Collections.unmodifiableMap(defaultVolumes);
    }
}

