/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.model.deployment;

import com.atlassian.bamboo.specs.api.codegen.annotations.ConstructFrom;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import com.atlassian.bamboo.specs.api.util.ReleaseNamingHelper;
import com.atlassian.bamboo.specs.api.util.VariableUtils;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

@ConstructFrom(value={"nextVersionName"})
public class ReleaseNamingProperties
implements EntityProperties {
    private String nextVersionName;
    private boolean autoIncrement;
    private boolean applicableToBranches;
    private Set<String> variablesToAutoIncrement;

    protected ReleaseNamingProperties() {
        this.variablesToAutoIncrement = Collections.emptySet();
    }

    public ReleaseNamingProperties(String nextVersionName, boolean autoIncrement, boolean applicableToBranches, Set<String> variablesToAutoIncrement) {
        this.nextVersionName = nextVersionName;
        this.autoIncrement = autoIncrement;
        this.applicableToBranches = applicableToBranches;
        this.variablesToAutoIncrement = Collections.unmodifiableSet(new HashSet<String>(variablesToAutoIncrement));
        this.validate();
    }

    public String getNextVersionName() {
        return this.nextVersionName;
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public boolean isApplicableToBranches() {
        return this.applicableToBranches;
    }

    public Set<String> getVariablesToAutoIncrement() {
        return this.variablesToAutoIncrement;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReleaseNamingProperties that = (ReleaseNamingProperties)o;
        return this.isAutoIncrement() == that.isAutoIncrement() && this.isApplicableToBranches() == that.isApplicableToBranches() && Objects.equals(this.getNextVersionName(), that.getNextVersionName()) && Objects.equals(this.getVariablesToAutoIncrement(), that.getVariablesToAutoIncrement());
    }

    public int hashCode() {
        return Objects.hash(this.getNextVersionName(), this.isAutoIncrement(), this.isApplicableToBranches(), this.getVariablesToAutoIncrement());
    }

    @Override
    public void validate() {
        ValidationContext context = ValidationContext.of("Release naming");
        ImporterUtils.checkRequiredNotBlank(context.with("nextVersionName"), this.nextVersionName);
        if (this.autoIncrement) {
            ReleaseNamingHelper.SplitVersionName splitVersionName = ReleaseNamingHelper.splitVersionName(this.nextVersionName);
            ImporterUtils.checkThat(context, splitVersionName.getNumberToIncrement() != null, "Cannot identify any numerical values in version to automatically increment", new Object[0]);
        }
        ArrayList<ValidationProblem> errors = new ArrayList<ValidationProblem>();
        ValidationContext nextVersionContext = context.with("nextVersionName");
        List<VariableUtils.VariableUsage> variableUsages = VariableUtils.findVariableUsages(this.nextVersionName);
        variableUsages.stream().map(v -> v.getNamespace() + '.' + v.getName()).filter(VariableUtils::isPasswordVariable).forEach(v -> errors.add(new ValidationProblem(nextVersionContext, "Variable %s is password variable and cannot be used in version name", v)));
        ValidationContext variablesToAutoIncrementContext = context.with("variablesToAutoIncrement");
        this.variablesToAutoIncrement.stream().filter(VariableUtils::isPasswordVariable).forEach(v -> errors.add(new ValidationProblem(variablesToAutoIncrementContext, "Variable %s is password variable and cannot be automatically incremented", v)));
        Set variablesUsedInName = variableUsages.stream().map(VariableUtils.VariableUsage::getName).collect(Collectors.toSet());
        this.variablesToAutoIncrement.stream().filter(v -> !variablesUsedInName.contains(v)).forEach(v -> errors.add(new ValidationProblem(variablesToAutoIncrementContext, "Variable %s is not used in version naming pattern", v)));
        ImporterUtils.checkNoErrors(errors);
    }
}

