/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.builders.permission;

import com.atlassian.bamboo.specs.api.builders.BambooKey;
import com.atlassian.bamboo.specs.api.builders.RootEntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.builders.permission.Permissions;
import com.atlassian.bamboo.specs.api.builders.repository.VcsRepositoryIdentifier;
import com.atlassian.bamboo.specs.api.model.permission.ProjectPermissionsProperties;
import com.atlassian.bamboo.specs.api.model.repository.VcsRepositoryIdentifierProperties;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ProjectPermissions
extends RootEntityPropertiesBuilder<ProjectPermissionsProperties> {
    public static final String TYPE = "project permissions";
    @NotNull
    private final BambooKey projectKey;
    private Permissions projectPermissions = new Permissions();
    private Permissions projectPlanPermissions = new Permissions();
    private List<VcsRepositoryIdentifierProperties> specsRepositories = new ArrayList<VcsRepositoryIdentifierProperties>();

    public ProjectPermissions(BambooKey projectKey) {
        ImporterUtils.checkNotNull("projectKey", projectKey);
        this.projectKey = projectKey;
    }

    public ProjectPermissions(String projectKey) {
        ImporterUtils.checkNotNull("projectKey", projectKey);
        this.projectKey = new BambooKey(projectKey);
    }

    public ProjectPermissions projectPermissions(@NotNull Permissions projectPermissions) {
        ImporterUtils.checkNotNull("projectPermissions", projectPermissions);
        this.projectPermissions = projectPermissions;
        return this;
    }

    public ProjectPermissions projectPlanPermissions(@NotNull Permissions projectPlanPermissions) {
        ImporterUtils.checkNotNull("projectPlanPermissions", projectPlanPermissions);
        this.projectPlanPermissions = projectPlanPermissions;
        return this;
    }

    public ProjectPermissions specsRepositories(String ... repositoriesNames) {
        ImporterUtils.checkNotNull("repositoriesNames", repositoriesNames);
        Arrays.stream(repositoriesNames).map(VcsRepositoryIdentifier::new).map(EntityPropertiesBuilders::build).forEach(this.specsRepositories::add);
        return this;
    }

    @NotNull
    public BambooKey getProjectKey() {
        return this.projectKey;
    }

    public Permissions getProjectPermissions() {
        return this.projectPermissions;
    }

    public Permissions getProjectPlanPermissions() {
        return this.projectPlanPermissions;
    }

    @Override
    protected ProjectPermissionsProperties build() {
        return new ProjectPermissionsProperties(this.projectKey, this.projectPermissions, this.projectPlanPermissions, this.specsRepositories);
    }

    @Override
    public String humanReadableType() {
        return TYPE;
    }

    @Override
    public String humanReadableId() {
        return String.format("%s for project %s", TYPE, this.projectKey);
    }
}

