/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.seraph.v25;

import com.atlassian.bamboo.security.ImpersonationHelper;
import com.atlassian.bamboo.setup.BootstrapManager;
import com.atlassian.bamboo.user.Authority;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.integration.http.CrowdHttpAuthenticator;
import com.atlassian.crowd.integration.http.CrowdHttpAuthenticatorImpl;
import com.atlassian.crowd.integration.http.util.CrowdHttpTokenHelper;
import com.atlassian.crowd.integration.http.util.CrowdHttpTokenHelperImpl;
import com.atlassian.crowd.integration.http.util.CrowdHttpValidationFactorExtractor;
import com.atlassian.crowd.integration.http.util.CrowdHttpValidationFactorExtractorImpl;
import com.atlassian.crowd.integration.rest.service.factory.RestCrowdClientFactory;
import com.atlassian.crowd.integration.seraph.CrowdAuthenticator;
import com.atlassian.crowd.service.client.ClientProperties;
import com.atlassian.crowd.service.client.ClientPropertiesImpl;
import com.atlassian.crowd.service.client.ClientResourceLocator;
import com.atlassian.crowd.service.client.CrowdClient;
import com.atlassian.crowd.service.client.ResourceLocator;
import com.atlassian.spring.container.ContainerManager;
import io.atlassian.util.concurrent.Lazy;
import java.lang.reflect.Proxy;
import java.security.Principal;
import java.util.function.Supplier;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.providers.anonymous.AnonymousAuthenticationToken;
import org.acegisecurity.ui.AuthenticationDetailsSourceImpl;
import org.apache.log4j.Logger;

public class BambooAuthenticator
extends CrowdAuthenticator {
    private static final Logger log = Logger.getLogger(BambooAuthenticator.class);
    private static final Supplier<CrowdHttpAuthenticator> crowdHttpAuthenticator = Lazy.supplier(() -> {
        String configDirectory = ((BootstrapManager)ContainerManager.getComponent((String)"bootstrapManager")).getConfigDirectory();
        ClientResourceLocator clientResourceLocator = new ClientResourceLocator("crowd.properties", configDirectory);
        log.info((Object)("Reading crowd.properties from " + configDirectory));
        ClientPropertiesImpl clientProperties = ClientPropertiesImpl.newInstanceFromResourceLocator((ResourceLocator)clientResourceLocator);
        RestCrowdClientFactory clientFactory = new RestCrowdClientFactory();
        CrowdClient crowdClient = clientFactory.newInstance((ClientProperties)clientProperties);
        CrowdHttpTokenHelper tokenHelper = CrowdHttpTokenHelperImpl.getInstance((CrowdHttpValidationFactorExtractor)CrowdHttpValidationFactorExtractorImpl.getInstance());
        return new CrowdHttpAuthenticatorImpl(crowdClient, (ClientProperties)clientProperties, tokenHelper);
    });

    public BambooAuthenticator() {
        super(BambooAuthenticator.newAuthenticator(), BambooAuthenticator::getCrowdService);
    }

    private static CrowdService getCrowdService() {
        return (CrowdService)ContainerManager.getComponent((String)"crowdService");
    }

    protected Principal getUser(String username) {
        try {
            return BambooAuthenticator.getCrowdService().getUser(username);
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private Authentication createAuthentication(ServletRequest request) {
        AnonymousAuthenticationToken auth = new AnonymousAuthenticationToken("anonymous", (Object)"anonymousUser", new GrantedAuthority[]{Authority.ANONYMOUS});
        auth.setDetails(new AuthenticationDetailsSourceImpl().buildDetails((HttpServletRequest)request));
        return auth;
    }

    protected void logoutUser(HttpServletRequest request) {
        ImpersonationHelper.newAuthenticationForCurrentThread((Authentication)this.createAuthentication((ServletRequest)request));
    }

    private static CrowdHttpAuthenticator newAuthenticator() {
        return (CrowdHttpAuthenticator)Proxy.newProxyInstance(BambooAuthenticator.class.getClassLoader(), new Class[]{CrowdHttpAuthenticator.class}, (proxy, method, args) -> method.invoke((Object)crowdHttpAuthenticator.get(), args));
    }
}

