/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded;

import com.atlassian.crowd.dao.application.ApplicationDAO;
import com.atlassian.crowd.directory.InternalDirectory;
import com.atlassian.crowd.embedded.EmbeddedCrowdBootstrap;
import com.atlassian.crowd.embedded.api.ApplicationFactory;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationType;
import com.atlassian.crowd.model.application.ImmutableApplication;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.springframework.transaction.annotation.Transactional;

public class EmbeddedCrowdBootstrapImpl
implements EmbeddedCrowdBootstrap {
    public static final String INTERNAL_DIRECTORY_NAME = "Bamboo Internal Directory";
    @Inject
    private ApplicationFactory applicationFactory;
    @Inject
    private ApplicationDAO applicationDao;
    @Inject
    private DirectoryDao directoryDao;

    @Override
    @Transactional
    public void initialiseEmbeddedCrowd() throws ApplicationNotFoundException, DirectoryNotFoundException {
        this.initialiseEmbeddedCrowd(true);
    }

    @Override
    @Transactional
    public void initialiseEmbeddedCrowd(boolean isInternalDirectoryActive) throws ApplicationNotFoundException, DirectoryNotFoundException {
        Application embeddedCrowdApp = this.getOrCreateApplication();
        Directory directory = this.createInternalDirectory(isInternalDirectoryActive);
        this.applicationDao.addDirectoryMapping(embeddedCrowdApp.getId().longValue(), directory.getId().longValue(), true, OperationType.values());
    }

    @Override
    @Transactional
    public Application getOrCreateApplication() {
        Application application = this.applicationFactory.getApplication();
        if (application == null) {
            this.createApplication();
        }
        return this.applicationFactory.getApplication();
    }

    @Override
    public Directory createInternalDirectory() {
        return this.createInternalDirectory(true);
    }

    @Override
    public Directory createInternalDirectory(boolean active) {
        DirectoryImpl directory = new DirectoryImpl(INTERNAL_DIRECTORY_NAME, DirectoryType.INTERNAL, InternalDirectory.class.getCanonicalName());
        directory.setDescription("Bamboo default internal directory");
        HashMap<String, String> directoryAttributes = new HashMap<String, String>();
        directoryAttributes.put("user_encryption_method", "atlassian-security");
        directory.setActive(active);
        directory.setAttributes(directoryAttributes);
        directory.setAllowedOperations((Set)Sets.newHashSet((Object[])OperationType.values()));
        return this.directoryDao.add((Directory)directory);
    }

    private void createApplication() {
        ImmutableApplication application = ImmutableApplication.builder((String)this.applicationFactory.getApplicationName(), (ApplicationType)ApplicationType.CROWD).setCreatedDate(new Date()).setUpdatedDate(new Date()).setActive(true).setMembershipAggregationEnabled(true).setAttributes((Map)ImmutableMap.of((Object)"atlassian_sha1_applied", (Object)Boolean.TRUE.toString(), (Object)"aggregateMemberships", (Object)Boolean.TRUE.toString())).build();
        this.applicationDao.add((Application)application, PasswordCredential.NONE);
    }
}

