/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.sw;

import com.ctc.wstx.api.InvalidCharHandler;
import com.ctc.wstx.api.WriterConfig;
import com.ctc.wstx.io.CharsetNames;
import com.ctc.wstx.io.UTF8Writer;
import com.ctc.wstx.stax.WstxOutputFactory;
import com.ctc.wstx.sw.AsciiXmlWriter;
import com.ctc.wstx.sw.ISOLatin1XmlWriter;
import com.ctc.wstx.sw.RestrictedCharsAwareBufferingXmlWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.stax2.XMLStreamWriter2;

public class BambooWstxOutputFactory
extends WstxOutputFactory {
    public XMLStreamWriter createXMLStreamWriter(OutputStream out, String enc) throws XMLStreamException {
        if (out == null) {
            throw new IllegalArgumentException("Null OutputStream is not a valid argument");
        }
        return this.createSW(out, null, enc, false);
    }

    private XMLStreamWriter2 createSW(OutputStream out, Writer w, String enc, boolean requireAutoClose) throws XMLStreamException {
        RestrictedCharsAwareBufferingXmlWriter xw;
        boolean autoCloseOutput;
        WriterConfig cfg = this.mConfig.createNonShared();
        cfg.setInvalidCharHandler((InvalidCharHandler)new InvalidCharHandler.ReplacingHandler('_'));
        boolean bl = autoCloseOutput = requireAutoClose || this.mConfig.willAutoCloseOutput();
        if (w == null) {
            if (enc == null) {
                enc = "UTF-8";
            } else if (enc != "UTF-8" && enc != "ISO-8859-1" && enc != "US-ASCII") {
                enc = CharsetNames.normalize((String)enc);
            }
            try {
                if (enc == "UTF-8") {
                    w = new UTF8Writer(cfg, out, autoCloseOutput);
                    xw = new RestrictedCharsAwareBufferingXmlWriter(w, cfg, enc, autoCloseOutput, out, 16);
                }
                if (enc == "ISO-8859-1") {
                    xw = new ISOLatin1XmlWriter(out, cfg, autoCloseOutput);
                }
                if (enc == "US-ASCII") {
                    xw = new AsciiXmlWriter(out, cfg, autoCloseOutput);
                }
                w = new OutputStreamWriter(out, enc);
                xw = new RestrictedCharsAwareBufferingXmlWriter(w, cfg, enc, autoCloseOutput, out, -1);
            }
            catch (IOException ex) {
                throw new XMLStreamException(ex);
            }
        } else {
            if (enc == null) {
                enc = CharsetNames.findEncodingFor((Writer)w);
            }
            try {
                xw = new RestrictedCharsAwareBufferingXmlWriter(w, cfg, enc, autoCloseOutput, null, -1);
            }
            catch (IOException ex) {
                throw new XMLStreamException(ex);
            }
        }
        return this.createSW(enc, cfg, xw);
    }
}

