/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils.properties;

import com.atlassian.bamboo.utils.properties.PropertyProvider;
import com.atlassian.bamboo.utils.properties.PropertyProviders;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChainedPropertyProvider
implements PropertyProvider {
    protected final List<PropertyProvider> propertyProviders;

    ChainedPropertyProvider(@NotNull Iterable<PropertyProvider> propertyProviders) {
        this.propertyProviders = ImmutableList.copyOf(propertyProviders);
    }

    @Override
    public boolean hasProperty(@NotNull String key) {
        return this.propertyProviders.stream().anyMatch(PropertyProviders.hasProperty(key));
    }

    @Override
    @Nullable
    public String getProperty(@NotNull String key) {
        return this.propertyProviders.stream().filter(PropertyProviders.hasProperty(key)).findFirst().map(propertyProvider -> propertyProvider.getProperty(key)).orElse(null);
    }
}

