/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils.files;

import com.atlassian.bamboo.utils.files.BambooFileVisitor;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.function.Function;
import java.util.function.Predicate;

public class GlobTreeWalker {
    public static void walkFileTree(Path rootDir, Function<Path, FileVisitResult> callback, String globPattern) throws IOException {
        Files.walkFileTree(rootDir, new BambooFileVisitor(rootDir, GlobTreeWalker.newGlobPredicate(globPattern), callback));
    }

    private static Predicate<Path> newGlobPredicate(String globPattern) {
        PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher("glob:" + globPattern);
        return pathMatcher::matches;
    }
}

