/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils.files;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.function.Function;
import java.util.function.Predicate;

public class BambooFileVisitor
extends SimpleFileVisitor<Path> {
    private final Predicate<Path> predicate;
    private final Function<Path, FileVisitResult> callback;
    private final Path rootDir;

    public BambooFileVisitor(Path rootDir, Predicate<Path> predicate, Function<Path, FileVisitResult> callback) {
        this.rootDir = rootDir;
        this.predicate = predicate;
        this.callback = callback;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        super.visitFile(file, attrs);
        Path relativePath = this.rootDir.relativize(file);
        if (this.predicate.test(relativePath)) {
            return this.callback.apply(file);
        }
        return FileVisitResult.CONTINUE;
    }
}

