/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils.concurrent;

import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicBoolean;

public class DecayingBoolean {
    private final AtomicBoolean value;
    private final boolean decayValue;
    private final Duration ttl;
    private volatile Instant timeout;
    private volatile Runnable onDecay;

    public DecayingBoolean(boolean initialValue, Duration ttl) {
        this(initialValue, initialValue, ttl);
    }

    public DecayingBoolean(boolean initialValue, boolean decayValue, Duration ttl) {
        this.value = new AtomicBoolean(initialValue);
        this.ttl = ttl;
        this.decayValue = decayValue;
        this.resetTimeout();
    }

    public boolean get() {
        if (this.decayIfNeeded()) {
            this.runDecayHandler();
        }
        return this.value.get();
    }

    private void runDecayHandler() {
        if (this.onDecay != null) {
            this.onDecay.run();
        }
    }

    public boolean compareAndSet(boolean expect, boolean update) {
        boolean isDecayed = this.decayIfNeeded();
        boolean isSet = this.value.compareAndSet(expect, update);
        if (isSet && update != this.decayValue) {
            this.resetTimeout();
        }
        if (isDecayed) {
            this.runDecayHandler();
        }
        return isSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(boolean b) {
        Duration duration = this.ttl;
        synchronized (duration) {
            this.resetTimeout();
            this.value.set(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetTimeout() {
        Duration duration = this.ttl;
        synchronized (duration) {
            this.timeout = Instant.now().plus(this.ttl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean decayIfNeeded() {
        Duration duration = this.ttl;
        synchronized (duration) {
            if (Instant.now().isAfter(this.timeout)) {
                this.timeout = Instant.MAX;
                this.value.set(this.decayValue);
                return true;
            }
        }
        return false;
    }

    public DecayingBoolean onDecay(Runnable runnable) {
        this.onDecay = runnable;
        return this;
    }
}

