/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils.collections;

import com.atlassian.bamboo.utils.concurrent.BambooLocks;
import com.google.common.base.Function;
import com.google.common.cache.CacheStats;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AlwaysInvalidatingCacheDecorator<K, V>
implements LoadingCache<K, V> {
    private static final Logger log = Logger.getLogger(AlwaysInvalidatingCacheDecorator.class);
    private static final int MAX_ALLOWED_RETRIES = 1;
    private final ThreadLocal<AtomicInteger> timesInvalidateCalledFromGetThreadLocal = new ThreadLocal<AtomicInteger>(){

        @Override
        protected AtomicInteger initialValue() {
            return new AtomicInteger();
        }
    };
    private final LoadingCache<K, V> delegate;
    private final Function<Object, ReentrantLock> locks = BambooLocks.weakReentrantLockFactory();
    private final ReentrantReadWriteLock anyReadInProgress = new ReentrantReadWriteLock();

    public AlwaysInvalidatingCacheDecorator(LoadingCache<K, V> cache) {
        this.delegate = cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(@NotNull K key) throws ExecutionException {
        AtomicInteger timesInvalidateCalledFromGetAtomic = this.timesInvalidateCalledFromGetThreadLocal.get();
        ReentrantLock keyLock = (ReentrantLock)this.locks.apply(key);
        this.anyReadInProgress.readLock().lock();
        try {
            Object object;
            keyLock.lock();
            try {
                Object v;
                boolean hasInvalidateBeenCalled;
                int timesInvalidateCalledFromGet = timesInvalidateCalledFromGetAtomic.get();
                do {
                    int previousRetryCount = timesInvalidateCalledFromGet;
                    v = this.delegate.get(key);
                    timesInvalidateCalledFromGet = timesInvalidateCalledFromGetAtomic.get();
                    boolean bl = hasInvalidateBeenCalled = timesInvalidateCalledFromGet != previousRetryCount;
                    if (!hasInvalidateBeenCalled) continue;
                    log.info((Object)("Repeated invalidation on " + key));
                    this.delegate.invalidate(key);
                } while (hasInvalidateBeenCalled && timesInvalidateCalledFromGet <= 1);
                if (timesInvalidateCalledFromGet > 1) {
                    throw new IllegalStateException("loader invoked from get() called invalidate() more than 1 time(s)");
                }
                object = v;
                keyLock.unlock();
            }
            catch (Throwable throwable) {
                keyLock.unlock();
                throw throwable;
            }
            return (V)object;
        }
        finally {
            timesInvalidateCalledFromGetAtomic.set(0);
            this.anyReadInProgress.readLock().unlock();
        }
    }

    public ImmutableMap<K, V> getAll(Iterable<? extends K> keys) throws ExecutionException {
        return this.delegate.getAll(keys);
    }

    public void refresh(K key) {
        this.delegate.refresh(key);
    }

    public void putAll(Map<? extends K, ? extends V> m) {
        this.delegate.putAll(m);
    }

    @Nullable
    public V getIfPresent(Object key) {
        return (V)this.delegate.getIfPresent(key);
    }

    public V get(@NotNull K k, @NotNull Callable<? extends V> callable) throws ExecutionException {
        throw new UnsupportedOperationException();
    }

    public ImmutableMap<K, V> getAllPresent(@NotNull Iterable<?> keys) {
        return this.delegate.getAllPresent(keys);
    }

    public V getUnchecked(@NotNull K key) {
        try {
            return this.get(key);
        }
        catch (ExecutionException e) {
            throw new UncheckedExecutionException(e.getCause());
        }
    }

    public V apply(@NotNull K key) {
        return this.getUnchecked(key);
    }

    public void invalidate(@NotNull Object key) {
        ReentrantLock lock = (ReentrantLock)this.locks.apply(key);
        if (lock.isHeldByCurrentThread()) {
            this.timesInvalidateCalledFromGetThreadLocal.get().incrementAndGet();
        }
        lock.lock();
        try {
            this.delegate.invalidate(key);
        }
        finally {
            lock.unlock();
        }
    }

    public void invalidateAll() {
        this.anyReadInProgress.writeLock().lock();
        try {
            this.delegate.invalidateAll();
        }
        finally {
            this.anyReadInProgress.writeLock().unlock();
        }
    }

    public void invalidateAll(@NotNull Iterable<?> objects) {
        this.anyReadInProgress.writeLock().lock();
        try {
            this.delegate.invalidateAll(objects);
        }
        finally {
            this.anyReadInProgress.writeLock().unlock();
        }
    }

    public long size() {
        return this.delegate.size();
    }

    public CacheStats stats() {
        return this.delegate.stats();
    }

    public ConcurrentMap<K, V> asMap() {
        return this.delegate.asMap();
    }

    public void cleanUp() {
        this.delegate.cleanUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(@NotNull K k, @NotNull V v) {
        ReentrantLock keyLock = (ReentrantLock)this.locks.apply(k);
        this.anyReadInProgress.readLock().lock();
        try {
            keyLock.lock();
            try {
                this.delegate.put(k, v);
            }
            finally {
                keyLock.unlock();
            }
        }
        finally {
            this.anyReadInProgress.readLock().unlock();
        }
    }

    public static <K, V> LoadingCache<K, V> wrap(LoadingCache<K, V> cache) {
        return new AlwaysInvalidatingCacheDecorator<K, V>(cache);
    }
}

