/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;

public final class BambooOptionals {
    private BambooOptionals() {
    }

    public static <T> Stream<T> stream(Optional<T> o) {
        return o.map(Stream::of).orElseGet(Stream::empty);
    }

    public static <T> T get(Optional<T> o, String errorMessage) {
        Preconditions.checkState((boolean)o.isPresent(), (Object)errorMessage);
        return o.get();
    }

    public static <T> void withPresent(Optional<T> o, Consumer<? super T> consumer, String errorMessage) {
        Preconditions.checkState((boolean)o.isPresent(), (Object)errorMessage);
        o.ifPresent(consumer);
    }
}

