/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BambooNetworkUtils {
    private static final Logger log = Logger.getLogger(BambooNetworkUtils.class);
    private static final int CONNECTION_TIMEOUT = 5000;
    private static final LoadingCache<AddressCacheKey, InetAddress> reachableAddressCache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<AddressCacheKey, InetAddress>(){

        public InetAddress load(AddressCacheKey address) {
            InetAddress reachableIpV6Address = BambooNetworkUtils.getReachableIpV6Address(address.getAddress(), address.getPort());
            if (reachableIpV6Address == null) {
                throw new NullPointerException(address.getAddress() + " : " + address.getPort() + " is not reachable through any interface");
            }
            log.debug((Object)("Using " + reachableIpV6Address + " for " + address.getAddress()));
            return reachableIpV6Address;
        }
    });
    private static final Map<NetworkInterface, Integer> networkInterfacesUsability = new ConcurrentHashMap<NetworkInterface, Integer>();

    public static InetAddress getReachableAddress(String address, int port) {
        Inet6Address ipv6address;
        if (address.contains(":")) {
            ipv6address = (Inet6Address)BambooNetworkUtils.getInetAddressByName(address);
        } else {
            InetAddress inetAddress = BambooNetworkUtils.getInetAddressByName(address);
            if (inetAddress instanceof Inet4Address) {
                return inetAddress;
            }
            ipv6address = (Inet6Address)inetAddress;
        }
        try {
            return (InetAddress)reachableAddressCache.getUnchecked((Object)new AddressCacheKey(ipv6address, port));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static InetAddress getInetAddressByName(String host) {
        try {
            return InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static InetAddress getReachableIpV6Address(Inet6Address ipv6Address, int port) {
        InetAddress inetAddress = BambooNetworkUtils.getReachableIpV6Address(ipv6Address, null, port);
        if (inetAddress != null) {
            return inetAddress;
        }
        Collection<NetworkInterface> networkInterfaces = BambooNetworkUtils.getIpV6NetworkInterfaces();
        for (NetworkInterface netInterface : networkInterfaces) {
            InetAddress reachableIpV6Address = BambooNetworkUtils.getReachableIpV6Address(ipv6Address, netInterface.getIndex(), port);
            if (reachableIpV6Address == null) continue;
            networkInterfacesUsability.compute(netInterface, (networkInterface, occurrences) -> occurrences + 1);
            return reachableIpV6Address;
        }
        return null;
    }

    private static boolean isIpV6Capable(NetworkInterface netInterface) {
        return Collections.list(netInterface.getInetAddresses()).stream().anyMatch(addr -> addr instanceof Inet6Address);
    }

    @NotNull
    private static synchronized Collection<NetworkInterface> getIpV6NetworkInterfaces() {
        Enumeration<NetworkInterface> networkInterfaces;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            throw Throwables.propagate((Throwable)e);
        }
        Set currentInterfaces = Collections.list(networkInterfaces).stream().filter(BambooNetworkUtils::isIpV6Capable).collect(Collectors.toSet());
        HashSet<NetworkInterface> interfacesToRemove = new HashSet<NetworkInterface>(networkInterfacesUsability.keySet());
        interfacesToRemove.removeAll(currentInterfaces);
        for (NetworkInterface interfaceToRemove : interfacesToRemove) {
            networkInterfacesUsability.remove(interfaceToRemove);
        }
        for (NetworkInterface currentInterface : currentInterfaces) {
            networkInterfacesUsability.putIfAbsent(currentInterface, 0);
        }
        return networkInterfacesUsability.entrySet().stream().sorted(Collections.reverseOrder(Map.Entry.comparingByValue())).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static InetAddress getReachableIpV6Address(Inet6Address ipv6Address, @Nullable Integer scopeId, int port) {
        Inet6Address addressMaybeWithScope = scopeId == null ? ipv6Address : BambooNetworkUtils.getInetAddressByName(ipv6Address.getHostAddress() + "%" + scopeId);
        try (Socket socket = new Socket();){
            socket.connect(new InetSocketAddress(addressMaybeWithScope, port), 5000);
            Inet6Address inet6Address = addressMaybeWithScope;
            return inet6Address;
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private static final class AddressCacheKey {
        private final Inet6Address address;
        private final Integer port;

        private AddressCacheKey(Inet6Address address, int port) {
            this.address = address;
            this.port = port;
        }

        public Inet6Address getAddress() {
            return this.address;
        }

        public int getPort() {
            return this.port;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AddressCacheKey)) {
                return false;
            }
            AddressCacheKey that = (AddressCacheKey)o;
            return Objects.equals(this.address, that.address);
        }

        public int hashCode() {
            return Objects.hash(this.address);
        }
    }
}

