/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import com.atlassian.json.marshal.Jsonable;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.jetbrains.annotations.NotNull;

public class BambooDataProviderUtils {
    private BambooDataProviderUtils() {
    }

    @NotNull
    public static Jsonable memoize(@NotNull Jsonable jsonable) {
        return new MemoizingJsonable(jsonable);
    }

    private static class MemoizingJsonable
    implements Jsonable {
        private final Jsonable delegate;
        private String json;

        private MemoizingJsonable(@NotNull Jsonable delegate) {
            this.delegate = delegate;
        }

        public void write(Writer writer) throws IOException {
            if (this.json == null) {
                StringWriter stringWriter = new StringWriter();
                this.delegate.write((Writer)stringWriter);
                this.json = stringWriter.toString();
            }
            writer.write(this.json);
        }
    }
}

