/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils.properties;

import com.atlassian.bamboo.utils.properties.ChainedPropertyProvider;
import com.atlassian.bamboo.utils.properties.PrefixedPropertyProvider;
import com.atlassian.bamboo.utils.properties.PropertyProvider;
import com.atlassian.bamboo.utils.properties.SimplePropertyProvider;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyProviderBuilder {
    private static final Logger log = LoggerFactory.getLogger(PropertyProviderBuilder.class);
    private final List<PropertyProvider> propertyProviders = new LinkedList<PropertyProvider>();

    public PropertyProviderBuilder withProperties(@NotNull Properties properties) {
        this.propertyProviders.add(new SimplePropertyProvider(properties));
        return this;
    }

    public PropertyProviderBuilder withProperties(@NotNull Properties properties, @NotNull String propertyKeyPrefix) {
        this.propertyProviders.add(new PrefixedPropertyProvider(properties, propertyKeyPrefix));
        return this;
    }

    public PropertyProvider build() {
        return new ChainedPropertyProvider(this.propertyProviders);
    }
}

