/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils.properties;

import com.atlassian.bamboo.utils.properties.PropertyProvider;
import com.atlassian.bamboo.utils.properties.PropertyProviders;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChainedPropertyProvider
implements PropertyProvider {
    protected final List<PropertyProvider> propertyProviders;

    ChainedPropertyProvider(@NotNull Iterable<PropertyProvider> propertyProviders) {
        this.propertyProviders = ImmutableList.copyOf(propertyProviders);
    }

    @Override
    public boolean hasProperty(@NotNull String key) {
        return Iterables.any(this.propertyProviders, PropertyProviders.hasProperty(key));
    }

    @Override
    @Nullable
    public String getProperty(@NotNull String key) {
        Optional provider = Iterables.tryFind(this.propertyProviders, PropertyProviders.hasProperty(key));
        return provider.isPresent() ? ((PropertyProvider)provider.get()).getProperty(key) : null;
    }
}

