/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils.matchers;

import com.atlassian.bamboo.utils.matchers.MapWithSizeMatcher;
import com.atlassian.bamboo.utils.matchers.PredicateAppliesMatcher;
import com.google.common.base.Function;
import java.util.Map;
import java.util.function.Predicate;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jetbrains.annotations.NotNull;

public class BambooMatchers {
    private BambooMatchers() {
    }

    public static <T> Matcher<T> predicateApplies(@NotNull Predicate<T> predicate) {
        return PredicateAppliesMatcher.predicateApplies(predicate);
    }

    public static <F, T> Matcher<F> convertAndMatch(final @NotNull Function<F, T> conversion, @NotNull Matcher<? super T> subMatcher) {
        return new FeatureMatcher<F, T>(subMatcher, "Apply conversion", "conversion"){

            protected T featureValueOf(F actual) {
                return conversion.apply(actual);
            }
        };
    }

    public static <F, T> Matcher<F> convertAndMatch(final @NotNull java.util.function.Function<F, T> conversion, @NotNull Matcher<? super T> subMatcher) {
        return new FeatureMatcher<F, T>(subMatcher, "Apply conversion", "conversion"){

            protected T featureValueOf(F actual) {
                return conversion.apply(actual);
            }
        };
    }

    @NotNull
    public static <K, V> Matcher<Map<? extends K, ? extends V>> mapWithSize(@NotNull Matcher<? super Integer> sizeMatcher) {
        return new MapWithSizeMatcher(sizeMatcher);
    }

    @NotNull
    public static <K, V> Matcher<Map<? extends K, ? extends V>> mapWithSize(int size) {
        return BambooMatchers.mapWithSize((Matcher<? super Integer>)Matchers.equalTo((Object)size));
    }

    @NotNull
    public static <K, V> Matcher<Map<? extends K, ? extends V>> emptyMap() {
        return BambooMatchers.mapWithSize(0);
    }
}

