/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import com.google.common.base.Stopwatch;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public final class BambooLogUtils {
    private BambooLogUtils() {
    }

    private static Priority getLogLevel(long seconds, long infoThresholdSeconds, long warnThresholdSeconds, long errorThresholdSeconds) {
        if (seconds < infoThresholdSeconds) {
            return Level.DEBUG;
        }
        if (seconds < warnThresholdSeconds) {
            return Level.INFO;
        }
        if (seconds < errorThresholdSeconds) {
            return Level.WARN;
        }
        return Level.ERROR;
    }

    public static Priority getLogLevel(Stopwatch stopWatch, int infoThresholdSeconds, int warnThresholdSeconds, int errorThresholdSeconds) {
        return BambooLogUtils.getLogLevel(stopWatch.elapsed(TimeUnit.SECONDS), (long)infoThresholdSeconds, (long)warnThresholdSeconds, (long)errorThresholdSeconds);
    }

    public static void logOperationTime(Logger log, Stopwatch stopWatch, int infoThresholdSeconds, int warnThresholdSeconds, int errorThresholdSeconds, String operation) {
        Priority priority = BambooLogUtils.getLogLevel(stopWatch, infoThresholdSeconds, warnThresholdSeconds, errorThresholdSeconds);
        log.log(priority, (Object)(operation + " took " + stopWatch));
    }
}

