/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import com.atlassian.bamboo.utils.BambooFileAttributes;
import com.atlassian.bamboo.utils.BambooPathUtils;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import org.jetbrains.annotations.NotNull;

public class BambooFiles {
    public static boolean deleteQuietly(Path path) {
        try {
            BambooFiles.delete(path);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static void delete(Path path) throws IOException {
        try {
            Files.delete(path);
        }
        catch (AccessDeniedException e) {
            DosFileAttributeView fileAttributeView = Files.getFileAttributeView(path, DosFileAttributeView.class, new LinkOption[0]);
            if (fileAttributeView == null) {
                throw e;
            }
            BambooFiles.unsetReadOnly(fileAttributeView, e);
            Files.delete(path);
        }
    }

    private static void unsetReadOnly(DosFileAttributeView fileAttributeView, AccessDeniedException ade) throws AccessDeniedException {
        try {
            fileAttributeView.setReadOnly(false);
        }
        catch (IOException ignored) {
            throw ade;
        }
    }

    public static AutoRemoved autoRemoved(final Path path) {
        return new AutoRemoved(){

            @Override
            public void close() throws IOException {
                BambooPathUtils.forceDelete(path);
            }

            @Override
            public Path getPath() {
                return path;
            }
        };
    }

    public static QuietlyRemoved quietlyRemoved(final Path path) {
        return new QuietlyRemoved(){

            @Override
            public void close() {
                BambooPathUtils.deleteQuietly(path);
            }

            @Override
            public Path getPath() {
                return path;
            }
        };
    }

    public static Path createTempDirectory(Path dir, String prefix, FileAttribute<?> ... attrs) throws IOException {
        try {
            return Files.createTempDirectory(dir, prefix, attrs);
        }
        catch (NoSuchFileException ignored) {
            Files.createDirectories(dir, attrs);
            return Files.createTempDirectory(dir, prefix, attrs);
        }
    }

    public static void setReadOnly(Path path, boolean isReadOnly) throws IOException {
        BambooFileAttributes.FileAttributeVisitor setter = isReadOnly ? BambooFileAttributes.SET_READONLY : BambooFileAttributes.SET_WRITABLE;
        setter.accept(path);
    }

    public static void setExecutable(Path path, boolean isExecutable) throws IOException {
        BambooFileAttributes.FileAttributeVisitor setter = isExecutable ? BambooFileAttributes.SET_EXECUTABLE : BambooFileAttributes.SET_NON_EXECUTABLE;
        setter.accept(path);
    }

    public static Path resolvePathUnderParent(@NotNull Path parent, @NotNull String child) throws IOException {
        Path normalisedParent = parent.normalize();
        Path resolved = normalisedParent.resolve(child).normalize();
        if (!resolved.startsWith(normalisedParent)) {
            throw new IllegalArgumentException("Creation of " + child + " under " + parent + " would result in parent directory traversal");
        }
        return resolved;
    }

    public static interface QuietlyRemoved
    extends AutoRemoved {
        @Override
        public void close();
    }

    public static interface AutoRemoved
    extends AutoCloseable {
        @Override
        public void close() throws IOException;

        public Path getPath();
    }
}

