/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import java.util.Set;

class BambooFileAttributes {
    private static final Set<PosixFilePermission> POSIX_WRITE_PERMISSIONS = EnumSet.of(PosixFilePermission.OWNER_WRITE, PosixFilePermission.GROUP_WRITE, PosixFilePermission.OTHERS_WRITE);
    private static final Set<PosixFilePermission> POSIX_EXECUTABLE_PERMISSIONS = EnumSet.of(PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_EXECUTE);
    static final FileAttributeVisitor SET_READONLY = new ReadOnlyPermissionSetter(true);
    static final FileAttributeVisitor SET_WRITABLE = new ReadOnlyPermissionSetter(false);
    static final FileAttributeVisitor SET_EXECUTABLE = new ExecutablePermissionSetter(true);
    static final FileAttributeVisitor SET_NON_EXECUTABLE = new ExecutablePermissionSetter(false);

    BambooFileAttributes() {
    }

    private static final class ExecutablePermissionSetter
    extends FileAttributeVisitor {
        private final boolean isExecutable;

        ExecutablePermissionSetter(boolean isExecutable) {
            this.isExecutable = isExecutable;
        }

        @Override
        public void visitPosix(PosixFileAttributeView posixFileAttributeView) throws IOException {
            Set<PosixFilePermission> permissions = posixFileAttributeView.readAttributes().permissions();
            if (this.isExecutable) {
                permissions.addAll(POSIX_EXECUTABLE_PERMISSIONS);
            } else {
                permissions.removeAll(POSIX_EXECUTABLE_PERMISSIONS);
            }
            posixFileAttributeView.setPermissions(permissions);
        }

        @Override
        public void visitDos(DosFileAttributeView dosFileAttributeView) throws IOException {
        }
    }

    private static final class ReadOnlyPermissionSetter
    extends FileAttributeVisitor {
        private final boolean isReadOnly;

        private ReadOnlyPermissionSetter(boolean isReadOnly) {
            this.isReadOnly = isReadOnly;
        }

        @Override
        public void visitPosix(PosixFileAttributeView posixFileAttributeView) throws IOException {
            Set<PosixFilePermission> permissions = posixFileAttributeView.readAttributes().permissions();
            if (this.isReadOnly) {
                permissions.removeAll(POSIX_WRITE_PERMISSIONS);
            } else {
                permissions.addAll(POSIX_WRITE_PERMISSIONS);
            }
            posixFileAttributeView.setPermissions(permissions);
        }

        @Override
        public void visitDos(DosFileAttributeView dosFileAttributeView) throws IOException {
            dosFileAttributeView.setReadOnly(this.isReadOnly);
        }
    }

    static abstract class FileAttributeVisitor {
        FileAttributeVisitor() {
        }

        public void accept(Path path) throws IOException {
            PosixFileAttributeView posixFileAttributeView = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0]);
            if (posixFileAttributeView != null) {
                this.visitPosix(posixFileAttributeView);
                return;
            }
            DosFileAttributeView dosFileAttributeView = Files.getFileAttributeView(path, DosFileAttributeView.class, new LinkOption[0]);
            if (dosFileAttributeView != null) {
                this.visitDos(dosFileAttributeView);
                return;
            }
            throw new UnsupportedOperationException("Don't know how to handle attributes for " + path.getFileSystem().provider().getClass());
        }

        public abstract void visitPosix(PosixFileAttributeView var1) throws IOException;

        public abstract void visitDos(DosFileAttributeView var1) throws IOException;
    }
}

