/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.ObjectArrays;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class BambooCollectors {
    private BambooCollectors() {
    }

    public static <T> Collector<T, Collection<T>, T[]> toArray(Class<T> clazz) {
        return Collector.of(ArrayList::new, Collection::add, (l1, l2) -> {
            l1.addAll(l2);
            return l1;
        }, ts -> {
            Object[] array = ObjectArrays.newArray((Class)clazz, (int)ts.size());
            return ts.toArray(array);
        }, new Collector.Characteristics[0]);
    }

    @NotNull
    public static Collector<Map.Entry<String, String>, ?, Map<String, String>> toMap() {
        return Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue);
    }

    public static <K, V> Collector<V, ?, Map<K, V>> toMap(Function<V, K> keyGenerator) {
        return Collectors.toMap(keyGenerator, (? super T e) -> e);
    }

    public static <K, V, M extends Map<K, V>> Collector<V, ?, M> toMap(Function<V, K> keyGenerator, Supplier<M> mapSupplier) {
        return Collectors.toMap(keyGenerator, e -> e, BambooCollectors.throwingMerger(), mapSupplier);
    }

    public static <K, V> Collector<V, ?, Map<K, V>> toHashMap(Function<V, K> keyGenerator) {
        return Collectors.toMap(keyGenerator, e -> e, BambooCollectors.throwingMerger(), HashMap::new);
    }

    public static <T> BinaryOperator<T> throwingMerger() {
        return (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        };
    }

    public static <V, K> Collector<V, Multimap<K, V>, Multimap<K, V>> toMultimap(Function<V, K> keyGenerator) {
        return BambooCollectors.toMultimap(keyGenerator, HashMultimap::create);
    }

    @NotNull
    public static <V, K, M extends Multimap<K, V>> Collector<V, M, M> toMultimap(final Function<V, K> keyGenerator, final Supplier<M> multiMapSupplier) {
        return new Collector<V, M, M>(){

            @Override
            public Supplier<M> supplier() {
                return multiMapSupplier;
            }

            @Override
            public BiConsumer<M, V> accumulator() {
                return (multimap, v) -> multimap.put(keyGenerator.apply(v), v);
            }

            @Override
            public BinaryOperator<M> combiner() {
                return (m1, m2) -> {
                    m1.putAll(m2);
                    return m1;
                };
            }

            @Override
            public Function<M, M> finisher() {
                return v -> v;
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return Collections.emptySet();
            }
        };
    }
}

