/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.deployments.execution.events;

import com.atlassian.bamboo.deployments.execution.events.DeploymentTimingPoints;
import com.atlassian.bamboo.v2.build.timing.OutOfBandTimingPoint;
import com.atlassian.bamboo.v2.build.timing.TimingPoint;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class OutOfBandDeploymentTimingPoints {
    private static final Map<Class<? extends TimingPoint>, Class<? extends OutOfBandTimingPoint>> outOfBandTimingPointClasses = new HashMap<Class<? extends TimingPoint>, Class<? extends OutOfBandTimingPoint>>();

    @Nullable
    public static Class<? extends OutOfBandTimingPoint> getOobClassForTimingPoint(TimingPoint timingPoint) {
        return outOfBandTimingPointClasses.get(timingPoint.getClass());
    }

    static {
        outOfBandTimingPointClasses.put(DeploymentTimingPoints.AgentAssigned.class, AgentAssigned.class);
        outOfBandTimingPointClasses.put(DeploymentTimingPoints.ExecutionStarted.class, ExecutionStarted.class);
        outOfBandTimingPointClasses.put(DeploymentTimingPoints.Queued.class, Queued.class);
        outOfBandTimingPointClasses.put(DeploymentTimingPoints.ExecutionFinished.class, ExecutionFinished.class);
    }

    public static class ExecutionFinished
    extends DeploymentTimingPoints
    implements OutOfBandTimingPoint {
        private ExecutionFinished(DeploymentTimingPoints.ExecutionFinished timingPoint) {
            super(timingPoint.getDeploymentResultId(), timingPoint.getDate());
        }
    }

    public static class ExecutionStarted
    extends DeploymentTimingPoints
    implements OutOfBandTimingPoint {
        private ExecutionStarted(DeploymentTimingPoints.ExecutionStarted timingPoint) {
            super(timingPoint.getDeploymentResultId(), timingPoint.getDate());
        }
    }

    public static class Queued
    extends DeploymentTimingPoints
    implements OutOfBandTimingPoint {
        private Queued(DeploymentTimingPoints.Queued timingPoint) {
            super(timingPoint.getDeploymentResultId(), timingPoint.getDate());
        }
    }

    public static class AgentAssigned
    extends DeploymentTimingPoints
    implements OutOfBandTimingPoint {
        private final long agentId;

        private AgentAssigned(DeploymentTimingPoints.AgentAssigned timingPoint) {
            super(timingPoint.getDeploymentResultId(), timingPoint.getDate());
            this.agentId = timingPoint.getAgentId();
        }

        public long getAgentId() {
            return this.agentId;
        }
    }
}

