/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.deployments.execution.events;

import com.atlassian.bamboo.deployments.execution.events.DeploymentTimingPoints;
import com.atlassian.bamboo.v2.build.timing.OutOfBandTimingPoint;
import com.atlassian.bamboo.v2.build.timing.TimingPoint;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class OutOfBandDeploymentTimingPoints {
    private static final Map<Class<? extends TimingPoint>, Class<? extends OutOfBandTimingPoint>> outOfBandTimingPointClasses = new HashMap<Class<? extends TimingPoint>, Class<? extends OutOfBandTimingPoint>>();

    @Nullable
    public static Class<? extends OutOfBandTimingPoint> getOobClassForTimingPoint(TimingPoint timingPoint) {
        return outOfBandTimingPointClasses.get(timingPoint.getClass());
    }

    static {
        outOfBandTimingPointClasses.put(DeploymentTimingPoints.AgentAssigned.class, AgentAssigned.class);
        outOfBandTimingPointClasses.put(DeploymentTimingPoints.ExecutionStarted.class, ExecutionStarted.class);
        outOfBandTimingPointClasses.put(DeploymentTimingPoints.Queued.class, Queued.class);
    }

    public static class ExecutionStarted
    extends DeploymentTimingPoints.ExecutionStarted
    implements OutOfBandTimingPoint {
        private ExecutionStarted(DeploymentTimingPoints.ExecutionStarted timingPoint) {
            super(timingPoint.getDeploymentResultId(), timingPoint.getDate());
        }
    }

    public static class Queued
    extends DeploymentTimingPoints.Queued
    implements OutOfBandTimingPoint {
        private Queued(DeploymentTimingPoints.Queued timingPoint) {
            super(timingPoint.getDeploymentResultId(), timingPoint.getDate());
        }
    }

    public static class AgentAssigned
    extends DeploymentTimingPoints.AgentAssigned
    implements OutOfBandTimingPoint {
        private AgentAssigned(DeploymentTimingPoints.AgentAssigned timingPoint) {
            super(timingPoint.getDeploymentResultId(), timingPoint.getDate(), timingPoint.getAgentId());
        }
    }
}

