/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.deployments.versions.service;

import com.atlassian.bamboo.artifact.Artifact;
import com.atlassian.bamboo.deployments.projects.DeploymentProject;
import com.atlassian.bamboo.deployments.versions.DeploymentVersion;
import com.atlassian.bamboo.deployments.versions.DeploymentVersionState;
import com.atlassian.bamboo.deployments.versions.DeploymentVersionStatus;
import com.atlassian.bamboo.exception.WebValidationException;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.atlassian.user.User;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DeploymentVersionService {
    @NotNull
    public ErrorCollection validateCreateDeploymentVersion(long var1, @NotNull PlanResultKey var3, @Nullable String var4, @Nullable String var5);

    public boolean isVersionNameConflicting(long var1, @NotNull String var3);

    @NotNull
    public ErrorCollection validateDeploymentVersionRename(long var1, @NotNull DeploymentVersion var3, @Nullable String var4);

    @Deprecated
    @NotNull
    public DeploymentVersion createDeploymentVersion(long var1, @NotNull PlanResultKey var3) throws WebValidationException;

    @NotNull
    public DeploymentVersion getOrCreateDeploymentVersion(long var1, @NotNull PlanResultKey var3) throws WebValidationException;

    @NotNull
    public DeploymentVersion createDeploymentVersion(long var1, @NotNull PlanResultKey var3, @Nullable User var4, @Nullable String var5, @Nullable String var6) throws WebValidationException;

    @Nullable
    public DeploymentVersion getDeploymentVersion(long var1);

    @NotNull
    public Set<String> getResultPlanKeysHavingDeploymentProjectVersions(long var1);

    @NotNull
    public List<DeploymentVersion> getDeploymentProjectVersions(long var1);

    @NotNull
    public List<DeploymentVersion> searchVersionsByName(long var1, @NotNull String var3);

    @NotNull
    public List<DeploymentVersion> searchVersionsByBranch(long var1, @NotNull PlanKey var3);

    @NotNull
    public List<DeploymentVersion> searchVersionsByBranchAndName(long var1, @NotNull PlanKey var3, @NotNull String var4);

    @Nullable
    public DeploymentVersion getDeploymentVersionByName(@NotNull String var1, long var2);

    public Set<PlanResultKey> getRelatedPlanResultKeys(long var1);

    public boolean isFromTheSameBranch(long var1, long var3);

    public boolean isFromTheSameBranch(String var1, long var2);

    @NotNull
    public DeploymentVersionStatus updateVersionStatus(long var1, @NotNull DeploymentVersionState var3, @NotNull String var4);

    @Nullable
    public DeploymentVersionStatus getLatestVersionStatus(long var1);

    @NotNull
    public List<DeploymentVersion> findVersionsBetween(long var1, @NotNull DeploymentVersion var3, @NotNull DeploymentVersion var4);

    @Nullable
    public DeploymentVersion findPreviousVersion(long var1, long var3);

    public int getVersionsCount();

    public int getVersionsCountForProject(long var1);

    @Deprecated
    @Nullable
    public DeploymentVersion getLatestVersionForProject(long var1);

    @Nullable
    public DeploymentVersion getLatestVersionForProject(long var1, @NotNull PlanKey var3);

    @NotNull
    public Multimap<String, Artifact> getVersionArtifacts(@NotNull DeploymentVersion var1);

    @Nullable
    public DeploymentVersion getRelatedVersion(long var1, @NotNull PlanResultKey var3);

    public DeploymentVersion findNextVersionContainingResult(long var1, @NotNull PlanResultKey var3);

    @NotNull
    public Map<String, VariableDefinitionContext> getPossibleVersionVariables(@NotNull ImmutablePlan var1, boolean var2);

    @NotNull
    public Map<String, VariableDefinitionContext> getPossibleVersionVariables(@NotNull ImmutablePlan var1, @Nullable PlanResultKey var2, boolean var3);

    @NotNull
    public String getIncrementedVersionName(@NotNull String var1);

    @NotNull
    public String getEvaluatedVersionName(String var1, Map<String, VariableDefinitionContext> var2, Set<String> var3);

    public void updatePlanKey(@NotNull PlanKey var1, @NotNull PlanKey var2);

    @NotNull
    public DeploymentVersion renameVersion(long var1, @NotNull DeploymentVersion var3, @NotNull String var4) throws WebValidationException;

    @NotNull
    public List<DeploymentVersion> findVersionsAssociatedWithJiraIssue(long var1, @NotNull String var3);

    @NotNull
    public Multimap<DeploymentProject, DeploymentVersion> findVersionsAssociatedWithJiraIssue(@NotNull String var1);

    @NotNull
    public Map<DeploymentVersion, Integer> findLatestKnownVersionsForEnvironmentsOfDeploymentProject(DeploymentProject var1);

    public boolean hasVersionsUnrelatedToBranch(long var1, @NotNull PlanKey var3);

    public String getVersionNamePreview(ResultsSummary var1, String var2);

    public void resetVersionsAge(@NotNull DeploymentVersion var1);
}

