/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.deployments.projects.service;

import com.atlassian.annotations.PublicApi;
import com.atlassian.bamboo.artifact.Artifact;
import com.atlassian.bamboo.deployments.projects.DeploymentProject;
import com.atlassian.bamboo.deployments.projects.DeploymentProjectItem;
import com.atlassian.bamboo.deployments.projects.DeploymentProjectStatusForResultSummary;
import com.atlassian.bamboo.deployments.projects.DeploymentProjectWithEnvironmentStatuses;
import com.atlassian.bamboo.deployments.projects.service.ArtifactValidationError;
import com.atlassian.bamboo.deployments.projects.versionnaming.VersionNamingScheme;
import com.atlassian.bamboo.exception.WebValidationException;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinition;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PublicApi
public interface DeploymentProjectService {
    @NotNull
    public List<DeploymentProject> getAllDeploymentProjects();

    @NotNull
    public List<DeploymentProject> getDeploymentProjectsRelatedToPlan(@NotNull PlanKey var1);

    @NotNull
    public List<DeploymentProjectWithEnvironmentStatuses> getDeploymentProjectsWithStatusesRelatedToPlan(@NotNull PlanKey var1);

    @NotNull
    public List<DeploymentProjectStatusForResultSummary> getDeploymentProjectsWithStatusesRelatedToPlanResult(@NotNull ResultsSummary var1);

    @NotNull
    public List<DeploymentProject> getDeploymentProjectsRelatedToArtifact(@NotNull ArtifactDefinition var1);

    @Nullable
    public DeploymentProject getDeploymentProject(long var1);

    @Nullable
    public DeploymentProject getDeploymentProjectForEnvironment(long var1);

    @Nullable
    public DeploymentProject getDeploymentProjectForVersion(long var1);

    public void deleteDeploymentProject(long var1);

    @NotNull
    public ErrorCollection validateAddDeploymentProject(String var1, String var2, String var3);

    @NotNull
    public DeploymentProject addDeploymentProject(String var1, String var2, String var3) throws WebValidationException;

    @NotNull
    public ErrorCollection validateEditDeploymentProject(long var1, String var3, String var4, String var5);

    @NotNull
    public ErrorCollection validateArtifactTaskDefinitionOnPlanChange(long var1, String var3, Map<String, ArtifactValidationError> var4);

    @NotNull
    public DeploymentProject editDeploymentProject(long var1, String var3, String var4, String var5) throws WebValidationException;

    @NotNull
    public List<DeploymentProjectItem> getDeploymentProjectItems(long var1);

    @Nullable
    public DeploymentProjectItem getProjectItem(long var1);

    public void addArtifactProjectItem(long var1, @NotNull ArtifactDefinition var3);

    public void removeArtifactProjectItem(long var1, @NotNull ArtifactDefinition var3);

    public void removeProjectItem(long var1, long var3);

    @Nullable
    public VersionNamingScheme getVersionNamingScheme(long var1);

    @NotNull
    public String getIncrementedVersionName(@NotNull String var1);

    @NotNull
    public ErrorCollection validateVersionNamingScheme(long var1, String var3, boolean var4, @NotNull Set<String> var5);

    @NotNull
    public VersionNamingScheme updateVersionNamingScheme(long var1, String var3, boolean var4, @NotNull Set<String> var5) throws WebValidationException;

    public void unlinkDeploymentProjectsRelatedToPlan(@NotNull PlanKey var1);

    public List<DeploymentProject> getDeploymentProjectsReferencingArtifact(@NotNull Artifact var1);

    public void updatePlanKey(@NotNull PlanKey var1, @NotNull PlanKey var2);
}

