/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.webhook;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.variable.substitutor.VariableSubstitutor;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;

@Internal
public class WebhookToSend {
    private final String name;
    private final String payload;
    private final HttpHeaders headers;
    private final String url;
    private final HttpMethod method;
    private final String uuid;
    private AtomicInteger retries = new AtomicInteger(0);
    private final String planResultKey;
    private final Long deploymentResultId;
    private final String event;
    private final VariableSubstitutor variableSubstitutor;

    public WebhookToSend(String name, String payload, HttpHeaders headers, String url, HttpMethod method, String uuid, String planResultKey, Long deploymentResultId, String event, VariableSubstitutor variableSubstitutor) {
        this.name = name;
        this.payload = payload;
        this.headers = headers;
        this.url = url;
        this.method = method;
        this.uuid = uuid;
        this.planResultKey = planResultKey;
        this.deploymentResultId = deploymentResultId;
        this.event = event;
        this.variableSubstitutor = variableSubstitutor;
    }

    public String getPayload() {
        return this.payload;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public String getUrl() {
        return this.url;
    }

    public String getName() {
        return this.name;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public String getUuid() {
        return this.uuid;
    }

    public int incrementAndGetRetries() {
        return this.retries.incrementAndGet();
    }

    public AtomicInteger getRetries() {
        return this.retries;
    }

    public String getPlanResultKey() {
        return this.planResultKey;
    }

    public Long getDeploymentResultId() {
        return this.deploymentResultId;
    }

    public String getEvent() {
        return this.event;
    }

    public VariableSubstitutor getVariableSubstitutor() {
        return this.variableSubstitutor;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WebhookToSend{");
        sb.append("uuid='").append(this.uuid).append('\'');
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", payload='").append(this.payload).append('\'');
        sb.append(", headers=").append(this.headers);
        sb.append(", url='").append(this.url).append('\'');
        sb.append(", method=").append(this.method);
        sb.append(", retries=").append(this.retries);
        sb.append('}');
        return sb.toString();
    }
}

