/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils.db;

import org.jetbrains.annotations.NotNull;

public enum DatabaseType {
    HSQL("hsql", "database.type.hsql", "jdbc:hsqldb", "org.hsqldb.jdbcDriver", 0, true){

        @Override
        @NotNull
        public String generateUrl(@NotNull String hostName, @NotNull String database, int port) {
            return String.format("%1$s:%2$s/database/defaultdb", this.getProtocol(), "${bambooHome}");
        }
    }
    ,
    MSSQL("mssql", "database.type.mssql", "jdbc:sqlserver", "com.microsoft.sqlserver.jdbc.SQLServerDriver", 1433, false){

        @Override
        @NotNull
        public String generateUrl(@NotNull String hostName, @NotNull String database, int port) {
            return String.format("%1$s://%2$s:%3$d;databaseName=%4$s", this.getProtocol(), hostName, port, database);
        }
    }
    ,
    MYSQL("mysql", "database.type.mysql", "jdbc:mysql", "com.mysql.jdbc.Driver", 3306, false){

        @Override
        @NotNull
        public String generateUrl(@NotNull String hostName, @NotNull String database, int port) {
            return String.format("%1$s://%2$s:%3$d/%4$s?characterEncoding=utf8&useUnicode=true", this.getProtocol(), hostName, port, database);
        }
    }
    ,
    ORACLE("oracle", "database.type.oracle", "jdbc:oracle:thin", "oracle.jdbc.OracleDriver", 1521, false){

        @Override
        @NotNull
        public String generateUrl(@NotNull String hostName, @NotNull String service, int port) {
            return String.format("%1$s:@//%2$s:%3$d/%4$s", this.getProtocol(), hostName, port, service);
        }
    }
    ,
    POSTGRESQL("postgres", "database.type.postgresql", "jdbc:postgresql", "org.postgresql.Driver", 5432, false){

        @Override
        @NotNull
        public String generateUrl(@NotNull String hostName, @NotNull String database, int port) {
            return String.format("%1$s://%2$s:%3$d/%4$s", this.getProtocol(), hostName, port, database);
        }
    }
    ,
    H2("h2", "database.type.h2", "jdbc:h2", "org.h2.Driver", 9092, true){

        @Override
        @NotNull
        public String generateUrl(@NotNull String hostName, @NotNull String database, int port) {
            return String.format("%1$s://%2$s:%3$d/%4$s", this.getProtocol(), hostName, port, database);
        }
    };

    private final String key;
    private final String i18nKey;
    private final String protocol;
    private final String driverClassName;
    private final int defaultPort;
    private final boolean embedded;

    private DatabaseType(String key, String i18nKey, String protocol, String driverClassName, int defaultPort, boolean embedded) {
        this.key = key;
        this.i18nKey = i18nKey;
        this.protocol = protocol;
        this.driverClassName = driverClassName;
        this.defaultPort = defaultPort;
        this.embedded = embedded;
    }

    public String getKey() {
        return this.key;
    }

    public String getI18nKey() {
        return this.i18nKey;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public int getDefaultPort() {
        return this.defaultPort;
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    @NotNull
    public String generateUrl(@NotNull String hostName, @NotNull String database) {
        return this.generateUrl(hostName, database, this.defaultPort);
    }

    @NotNull
    public abstract String generateUrl(@NotNull String var1, @NotNull String var2, int var3);
}

