/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import com.atlassian.bamboo.utils.BambooCallables;
import com.atlassian.bamboo.utils.BambooRunnables;
import com.atlassian.util.profiling.Metrics;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class BambooProfilingUtils {
    private static final Logger log = Logger.getLogger(BambooProfilingUtils.class);

    private BambooProfilingUtils() {
    }

    @Deprecated
    public static <T> T withUtilTimerStack(@NotNull String message, Callable<T> callable) throws Exception {
        try (Ticker ignored = Timers.start((String)message);){
            T t = callable.call();
            return t;
        }
    }

    @Deprecated
    public static <T> T withUtilTimerStack(@NotNull String message, BambooCallables.NotThrowing<T> callable) {
        try (Ticker ignored = Timers.start((String)message);){
            Object v = callable.call();
            return (T)v;
        }
    }

    @Deprecated
    public static <T, E1 extends Throwable, E2 extends Throwable, E3 extends Throwable> T withUtilTimerStack(@NotNull String message, @NotNull BambooCallables.ThrowingX<T, E1, E2, E3> callable) throws E1, E2, E3 {
        try (Ticker ignored = Timers.start((String)message);){
            T t = callable.call();
            return t;
        }
    }

    @Deprecated
    public static <T> T withUtilTimerStack(@NotNull String message, Supplier<T> supplier) {
        try (Ticker ignored = Timers.start((String)message);){
            T t = supplier.get();
            return t;
        }
    }

    @Deprecated
    public static <E1 extends Throwable, E2 extends Throwable, E3 extends Throwable> void withUtilTimerStack(@NotNull String message, @NotNull BambooRunnables.ThrowingX<E1, E2, E3> runnable) throws E1, E2, E3 {
        try (Ticker ignored = Timers.start((String)message);){
            runnable.run();
        }
    }

    @Deprecated
    public static void withUtilTimerStack(@NotNull String message, Runnable runnable) {
        try (Ticker ignored = Timers.start((String)message);){
            runnable.run();
        }
    }

    public static boolean isUtilTimerStackActive() {
        return Timers.getConfiguration().isEnabled() || Metrics.getConfiguration().isEnabled();
    }

    public static String getTimes(@NotNull Map<Object, Long> profiledCalls, int minimumDurationMs) {
        StringBuilder sb = new StringBuilder();
        sb.append("Total calls: ").append(profiledCalls.size()).append("\n");
        sb.append("Accumulated times longer than ").append(minimumDurationMs).append(" ms:\n");
        BambooProfilingUtils.dumpAccumulatedTimes(sb, profiledCalls, minimumDurationMs);
        sb.append("\nIndividual times longer than ").append(minimumDurationMs).append(" ms:\n");
        BambooProfilingUtils.dumpSortedTimes(sb, profiledCalls, minimumDurationMs);
        return sb.toString();
    }

    private static void dumpAccumulatedTimes(@NotNull StringBuilder sb, @NotNull Map<Object, Long> profiledCalls, int longerThanMs) {
        HashMap<Object, Long> profiledAccumulatedCalls = new HashMap<Object, Long>();
        for (Map.Entry<Object, Long> profileEntry : profiledCalls.entrySet()) {
            String profiledObjectName = BambooProfilingUtils.genNameFromToString(profileEntry.getKey());
            Long oldValue = (Long)profiledAccumulatedCalls.get(profiledObjectName);
            if (oldValue == null) {
                oldValue = 0L;
            }
            profiledAccumulatedCalls.put(profiledObjectName, oldValue + profileEntry.getValue());
        }
        BambooProfilingUtils.dumpSortedTimes(sb, profiledAccumulatedCalls, longerThanMs);
    }

    private static void dumpSortedTimes(@NotNull StringBuilder sb, @NotNull Map<Object, Long> profiledCalls, int longerThanMs) {
        long longerThanNs = TimeUnit.MILLISECONDS.toNanos(longerThanMs);
        profiledCalls.entrySet().stream().filter(e -> (Long)e.getValue() >= longerThanNs).map(e -> new ProfileEntry(e.getKey(), (Long)e.getValue())).sorted((o1, o2) -> o2.getTime().compareTo(o1.getTime())).map(ProfileEntry::toString).forEach(s -> sb.append((String)s).append("\n"));
    }

    private static String genNameFromToString(@NotNull Object object) {
        String firstLine = StringUtils.substringBefore((String)StringUtils.substringBefore((String)object.toString(), (String)"\n"), (String)"\r");
        return StringUtils.substringBeforeLast((String)firstLine, (String)"@");
    }

    private static class ProfileEntry {
        private static final long DISPLAY_AS_MILLISECONDS = TimeUnit.MILLISECONDS.toNanos(2L);
        private static final long DISPLAY_AS_MICROSECONDS = TimeUnit.MICROSECONDS.toNanos(2L);
        private final Object object;
        private final Long time;

        public ProfileEntry(Object object, Long time) {
            this.object = object;
            this.time = time;
        }

        public Long getTime() {
            return this.time;
        }

        public String toString() {
            return this.getName() + " : " + this.getPrettyTime(this.time);
        }

        private String getName() {
            return BambooProfilingUtils.genNameFromToString(this.object);
        }

        private String getPrettyTime(long nanos) {
            if (nanos > DISPLAY_AS_MILLISECONDS) {
                return TimeUnit.NANOSECONDS.toMillis(nanos) + " ms";
            }
            if (nanos > DISPLAY_AS_MICROSECONDS) {
                return TimeUnit.NANOSECONDS.toMicros(nanos) + " MICROs";
            }
            return nanos + " NANOs";
        }
    }
}

