/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.task;

import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.v2.build.CommonContext;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaskContextHelper {
    private static final String TASK_CONTEXT_DEPLOYMENT_MODE = "deploymentMode";
    private static final String TASK_CONTEXT_RELATED_PLAN = "relatedPlan";
    private static final String TASK_CONTEXT_PLAN = "plan";

    private TaskContextHelper() {
    }

    @Nullable
    public static ImmutablePlan getPlan(@NotNull Map<String, Object> context) {
        return (ImmutablePlan)context.get(TASK_CONTEXT_PLAN);
    }

    public static void setPlan(@NotNull Map<String, Object> context, @NotNull ImmutablePlan plan) {
        context.put(TASK_CONTEXT_PLAN, plan);
    }

    public static boolean isDeploymentMode(@NotNull Map<String, Object> context) {
        return Boolean.TRUE.equals(context.get(TASK_CONTEXT_DEPLOYMENT_MODE));
    }

    public static void setDeploymentMode(@NotNull Map<String, Object> context, boolean value) {
        context.put(TASK_CONTEXT_DEPLOYMENT_MODE, value);
    }

    public static ImmutablePlan getRelatedPlan(@NotNull Map<String, Object> context) {
        return (ImmutablePlan)context.get(TASK_CONTEXT_RELATED_PLAN);
    }

    public static void setRelatedPlan(@NotNull Map<String, Object> context, @NotNull ImmutablePlan plan) {
        context.put(TASK_CONTEXT_RELATED_PLAN, plan);
    }

    public static void failIfDockerPipelinesEnabled(CommonContext commonContext) throws TaskException {
        if (commonContext.getDockerPipelineConfiguration().isEnabled()) {
            throw new TaskException("This task can't be executed in Docker. Use different task or run this build in Agent environment.");
        }
    }
}

