/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.results.warning;

import com.atlassian.bamboo.resultsummary.warning.BuildResultWarningSummary;
import java.io.Serializable;
import java.util.StringJoiner;
import org.jetbrains.annotations.NotNull;

public class BuildWarningSummary
implements Serializable {
    private long repositoryId;
    private long highPriorityCount;
    private long normalPriorityCount;
    private long lowPriorityCount;

    public BuildWarningSummary(long repositoryId, long highPriorityCount, long normalPriorityAmount, long lowPriorityCount) {
        this.repositoryId = repositoryId;
        this.highPriorityCount = highPriorityCount;
        this.normalPriorityCount = normalPriorityAmount;
        this.lowPriorityCount = lowPriorityCount;
    }

    public long getRepositoryId() {
        return this.repositoryId;
    }

    public long getHighPriorityCount() {
        return this.highPriorityCount;
    }

    public long getNormalPriorityCount() {
        return this.normalPriorityCount;
    }

    public long getLowPriorityCount() {
        return this.lowPriorityCount;
    }

    public void append(@NotNull BuildWarningSummary summary) {
        this.highPriorityCount += summary.getHighPriorityCount();
        this.normalPriorityCount += summary.getNormalPriorityCount();
        this.lowPriorityCount += summary.getLowPriorityCount();
    }

    public void append(@NotNull BuildResultWarningSummary summary) {
        this.highPriorityCount += summary.getHighPriorityCount();
        this.normalPriorityCount += summary.getNormalPriorityCount();
        this.lowPriorityCount += summary.getLowPriorityCount();
    }

    public String toString() {
        return new StringJoiner(", ", BuildWarningSummary.class.getSimpleName() + "[", "]").add("repositoryId=" + this.repositoryId).add("highPriorityCount=" + this.highPriorityCount).add("normalPriorityCount=" + this.normalPriorityCount).add("lowPriorityCount=" + this.lowPriorityCount).toString();
    }
}

