/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.build.Buildable;
import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.branch.ChainBranch;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableChainBranch;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

@Internal
public enum PlanType {
    CHAIN(Chain.class, ImmutableChain.class),
    JOB(Job.class, ImmutableJob.class),
    CHAIN_BRANCH(ChainBranch.class, ImmutableChainBranch.class);

    private final Class<? extends ImmutablePlan> immutableClass;
    private final boolean isChain;
    private final boolean isBuildable;
    private static final EnumSet<PlanType> chainPlanTypes;

    private PlanType(Class<? extends Plan> aClass, Class<? extends ImmutablePlan> immutableClass) {
        this.immutableClass = immutableClass;
        this.isChain = Chain.class.isAssignableFrom(aClass);
        this.isBuildable = Buildable.class.isAssignableFrom(aClass);
    }

    public Class<? extends ImmutablePlan> getImmutableClassType() {
        return this.immutableClass;
    }

    public boolean isChain() {
        return this.isChain;
    }

    public boolean isBuildable() {
        return this.isBuildable;
    }

    @NotNull
    public static EnumSet<PlanType> getChainPlanTypes() {
        return chainPlanTypes;
    }

    static {
        chainPlanTypes = EnumSet.copyOf(Arrays.stream(PlanType.values()).filter(PlanType::isChain).collect(Collectors.toList()));
    }
}

