/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.index;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SimpleCollector;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractDocumentHitCollector
extends SimpleCollector {
    private static final Logger log = Logger.getLogger(AbstractDocumentHitCollector.class);
    private volatile IndexSearcher indexSearcher;
    private volatile LeafReader leafReader;
    protected final SearcherFacade searcher = new SearcherFacade();

    public void doSetNextReader(LeafReaderContext context) {
        this.leafReader = context.reader();
    }

    public void collect(int docId) {
        try {
            Document doc = this.doc(docId);
            if (doc != null) {
                this.collect(doc);
            }
        }
        catch (IOException e) {
            log.warn((Object)("Unable to get document with id " + docId), (Throwable)e);
        }
    }

    protected Document doc(int docId) throws IOException {
        return this.searcher.doc(docId);
    }

    public void setScorer(Scorer scorer) throws IOException {
    }

    protected abstract void collect(@NotNull Document var1);

    @Deprecated
    public boolean acceptsDocsOutOfOrder() {
        return true;
    }

    public boolean needsScores() {
        log.warn((Object)("Your plugin is using a collector " + ((Object)((Object)this)).getClass() + " that does not specify whether it needs document scores"));
        return true;
    }

    protected class SearcherFacade {
        protected SearcherFacade() {
        }

        public Document doc(int docId) throws IOException {
            return AbstractDocumentHitCollector.this.indexSearcher != null ? AbstractDocumentHitCollector.this.indexSearcher.doc(docId) : AbstractDocumentHitCollector.this.leafReader.document(docId);
        }
    }
}

