/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.builder;

import com.atlassian.bamboo.ReasonForBuild;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.commit.Commit;
import com.atlassian.bamboo.results.BuildResults;
import com.atlassian.bamboo.results.BuildResultsImpl;
import java.io.File;
import java.util.Collections;
import java.util.List;

public class BuildResultsTestFactory {
    public static BuildResults createWithReasonCleanBuild() {
        return new BuildResultsImpl("KEY", BuildState.SUCCESS, null, null, ReasonForBuild.INITIAL_CLEAN_BUILD);
    }

    public static BuildResults createWithReason(ReasonForBuild expectedReason) {
        return new BuildResultsImpl("KEY", BuildState.SUCCESS, null, Collections.emptyList(), expectedReason);
    }

    public static BuildResults createWithSuccess() {
        return BuildResultsTestFactory.createWithChangeList(null);
    }

    public static BuildResults createWithFailure() {
        return new BuildResultsImpl("KEY", BuildState.FAILED, null, null, ReasonForBuild.CODE_HAS_CHANGED);
    }

    public static BuildResults createWithSourceDir(File expectedSourceDirectory) {
        return new BuildResultsImpl("KEY", BuildState.SUCCESS, null, Collections.emptyList(), ReasonForBuild.CODE_HAS_CHANGED);
    }

    public static BuildResults createWithBuildKey(String expectedBuildKey) {
        return new BuildResultsImpl(expectedBuildKey, BuildState.SUCCESS, null, Collections.emptyList(), ReasonForBuild.CODE_HAS_CHANGED);
    }

    public static BuildResults createWithChangeList(List<Commit> expectedChangeList) {
        return new BuildResultsImpl("KEY", BuildState.SUCCESS, null, expectedChangeList, ReasonForBuild.CODE_HAS_CHANGED);
    }

    public static BuildResults createWithNoReason() {
        return BuildResultsTestFactory.createWithReason(null);
    }
}

