/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build;

import com.atlassian.bamboo.build.LogEntry;
import com.atlassian.bamboo.build.LogEntryDateFormats;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.util.HtmlUtils;
import com.google.common.base.Preconditions;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleLogEntry
implements LogEntry {
    private final Date time;
    private final String log;

    public SimpleLogEntry(@NotNull String log) {
        this(log, new Date());
    }

    public SimpleLogEntry(@NotNull String log, @Nullable Date time) {
        this.time = time == null ? new Date(0L) : time;
        this.log = (String)Preconditions.checkNotNull((Object)log, (Object)"Log entry can't be null");
    }

    @Override
    public String getFormattedDate() {
        return LogEntryDateFormats.formatterInstance().format(this.time);
    }

    @Override
    public String getUsFormattedDate() {
        return LogEntryDateFormats.formatterInstanceLocaleUs().format(this.time);
    }

    @Override
    @NotNull
    public Date getDate() {
        return this.time;
    }

    @Override
    public void logTo(BuildLogger buildLogger) {
        buildLogger.addBuildLogEntry(this);
    }

    @Override
    public String getLog() {
        return HtmlUtils.colorizeAnsiToHtml(HtmlUtils.getAsPreformattedText(this.log));
    }

    @Override
    @Nullable
    public String getCssStyle() {
        return null;
    }

    @Override
    @NotNull
    public String getUnstyledLog() {
        return this.log;
    }

    public String toString() {
        return this.getUnstyledLog();
    }

    @Override
    public LogEntry cloneAndMutate(String newUnstyledLog) {
        return new SimpleLogEntry(newUnstyledLog, this.getDate());
    }
}

