/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.timing;

import com.atlassian.bamboo.v2.build.timing.OutOfBandTimingPoint;
import com.atlassian.bamboo.v2.build.timing.TimingPoint;
import com.google.common.base.Throwables;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class OutOfBandTimingPoints {
    public static OutOfBandTimingPoint oobTimingPointFor(Logger log, Class<? extends OutOfBandTimingPoint> oobTimingPoint, TimingPoint timingPoint) {
        try {
            Constructor<? extends OutOfBandTimingPoint> constructor = oobTimingPoint.getDeclaredConstructor(timingPoint.getClass());
            constructor.setAccessible(true);
            return constructor.newInstance(timingPoint);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            log.warn((Object)"Unable to instantiate a concrete OOB timing point class", (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Deprecated
    @Nullable
    public static Class<? extends OutOfBandTimingPoint> getOobClassForTimingPoint(Class<?> outOfBandBuildTimingPointsClass, TimingPoint timingPoint) {
        for (Class<?> oobClass : OutOfBandTimingPoints.getPotentialOobClasses(outOfBandBuildTimingPointsClass)) {
            if (!timingPoint.getClass().isAssignableFrom(oobClass)) continue;
            return oobClass;
        }
        return null;
    }

    public static List<Class<?>> getPotentialOobClasses(Class<?> outOfBandBuildTimingPointsClass) {
        Class<?>[] declaredClasses = outOfBandBuildTimingPointsClass.getDeclaredClasses();
        return Arrays.stream(declaredClasses).filter(OutOfBandTimingPoint.class::isAssignableFrom).collect(Collectors.toList());
    }
}

