/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.timing;

import com.atlassian.bamboo.v2.build.timing.AbstractBuildTimingPoint;
import com.atlassian.bamboo.v2.build.timing.BuildTimingPoints;
import com.atlassian.bamboo.v2.build.timing.OutOfBandTimingPoint;
import com.atlassian.bamboo.v2.build.timing.TimingPoint;
import com.google.common.base.MoreObjects;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class OutOfBandBuildTimingPoints {
    private static final Map<Class<? extends TimingPoint>, Class<? extends OutOfBandTimingPoint>> outOfBandTimingPointClasses = new HashMap<Class<? extends TimingPoint>, Class<? extends OutOfBandTimingPoint>>();

    @Nullable
    public static Class<? extends OutOfBandTimingPoint> getOobClassForTimingPoint(TimingPoint timingPoint) {
        return outOfBandTimingPointClasses.get(timingPoint.getClass());
    }

    static {
        outOfBandTimingPointClasses.put(BuildTimingPoints.AgentAssigned.class, OutOfBandAgentAssigned.class);
        outOfBandTimingPointClasses.put(BuildTimingPoints.ExecutionStarted.class, ExecutionStarted.class);
        outOfBandTimingPointClasses.put(BuildTimingPoints.VcsSyncStarted.class, VcsSyncStarted.class);
        outOfBandTimingPointClasses.put(BuildTimingPoints.ExecutionFinished.class, ExecutionFinished.class);
    }

    public static class VcsSyncStarted
    extends AbstractBuildTimingPoint
    implements OutOfBandTimingPoint {
        private VcsSyncStarted(BuildTimingPoints.VcsSyncStarted timingPoint) {
            super(timingPoint.getPlanResultKey(), timingPoint.getDate());
        }
    }

    public static class ExecutionFinished
    extends AbstractBuildTimingPoint
    implements OutOfBandTimingPoint {
        private ExecutionFinished(BuildTimingPoints.ExecutionFinished timingPoint) {
            super(timingPoint.getPlanResultKey(), timingPoint.getDate());
        }
    }

    public static class ExecutionStarted
    extends AbstractBuildTimingPoint
    implements OutOfBandTimingPoint {
        private ExecutionStarted(BuildTimingPoints.ExecutionStarted timingPoint) {
            super(timingPoint.getPlanResultKey(), timingPoint.getDate());
        }
    }

    public static class OutOfBandAgentAssigned
    extends AbstractBuildTimingPoint
    implements OutOfBandTimingPoint {
        private final long agentId;

        private OutOfBandAgentAssigned(BuildTimingPoints.AgentAssigned timingPoint) {
            super(timingPoint.getPlanResultKey(), timingPoint.getDate());
            this.agentId = timingPoint.getAgentId();
        }

        public long getAgentId() {
            return this.agentId;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("date", (Object)this.getDate()).add("planResultKey", (Object)this.getPlanResultKey()).add("agentId", this.getAgentId()).toString();
        }
    }
}

