/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import com.atlassian.bamboo.util.UrlUtils;
import com.atlassian.bamboo.utils.AbstractSystemProperty;
import com.google.common.annotations.VisibleForTesting;
import java.time.Duration;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class SystemProperty
extends AbstractSystemProperty {
    public static final String BAMBOO_HOME_PROPERTY_NAME = "bamboo.home";
    public static final String BAMBOO_AGENT_BROKER_URL_PROPERTY_NAME = "bamboo.agent.brokerUrl";
    public static final SystemProperty BAMBOO_HOME_FROM_ENV = new SystemProperty(false, "bamboo.home", "BAMBOO_HOME");
    public static final SystemProperty MAVEN_HOME = new SystemProperty(false, "MAVEN_HOME");
    public static final SystemProperty MAVEN2_HOME = new SystemProperty(false, "M2_HOME", "MAVEN2_HOME");
    public static final SystemProperty ANT_HOME = new SystemProperty(false, "ANT_HOME");
    public static final SystemProperty DEFAULT_CVS_ROOT = new SystemProperty(false, "CVSROOT");
    public static final SystemProperty DEFAULT_PERFORCE_PORT = new SystemProperty(false, "P4PORT");
    public static final SystemProperty DEFAULT_PERFORCE_CLIENT = new SystemProperty(false, "P4CLIENT");
    public static final SystemProperty DEFAULT_PERFORCE_USER = new SystemProperty(false, "P4USER");
    public static final SystemProperty DEFAULT_P4_EXE = new SystemProperty(false, "P4EXE");
    public static final SystemProperty FIND_SUCCESS_MESSAGE_IN_LAST = new SystemProperty(false, "SUCCESS_MESSAGE_LINES");
    public static final SystemProperty BUILD_SUCCESSFUL_MARKER = new SystemProperty(false, "atlassian.bamboo.builder.successMarker");
    public static final SystemProperty BUILD_FAILED_MARKER = new SystemProperty(false, "atlassian.bamboo.builder.failedMarker");
    public static final SystemProperty SEARCH_BUILD_SUCCESS_FAIL_MESSAGE_EVERYWHERE = new SystemProperty(false, "bamboo.build.searchSuccessFailMessageEverywhere");
    public static final BooleanSystemProperty DISABLE_AGENT_AUTO_CAPABILITY_DETECTION = new BooleanSystemProperty(false, false, "DISABLE_AGENT_AUTO_CAPABILITY_DETECTION");
    public static final SystemProperty SVN_SPOOL_TO_FILE = new SystemProperty(false, "SVN_SPOOL_TO_FILE");
    public static final SystemProperty BUILDING_DISABLED = new SystemProperty(false, "atlassian.bamboo.build.disable");
    public static final SystemProperty PATH = new SystemProperty(false, "PATH", "Path", "path");
    public static final SystemProperty CVS_TIME_DIFF = new SystemProperty(false, "atlassian.bamboo.cvsTimeDiff");
    public static final SystemProperty CVS_CHECKOUT_FORMAT = new SystemProperty(false, "CVS_CHECKOUT_FORMAT");
    public static final SystemProperty CVS_FORCE_CHECKOUT_TO_LATEST = new SystemProperty(false, "CVS_FORCE_CHECKOUT_TO_LATEST");
    public static final int CVS_SOCKET_TIMEOUT_MS = new SystemProperty(false, "CVS_SOCKET_TIMEOUT_MS").getValue((int)Duration.ofMinutes(1L).toMillis());
    public static final SystemProperty BUILD_RESULTS_CACHE_SIZE = new SystemProperty(false, "BUILD_RESULTS_CACHE_SIZE");
    public static final SystemProperty FILTER_MAVEN_LOG_FOR_DOWNLOAD_STATUS = new SystemProperty(false, "FILTER_MAVEN_LOG_FOR_DOWNLOAD_STATUS");
    @Deprecated
    public static final SystemProperty SVN_WC_FORMAT = new SystemProperty(false, "bamboo.svn.wc.format");
    public static final SystemProperty SVN_CACHE_CREDENTIALS = new SystemProperty(false, "bamboo.svn.cache.credentials");
    public static final IntegerSystemProperty LOG_LINES_FOR_NOTIFICATIONS = new IntegerSystemProperty(false, 100L, "bamboo.notifications.logLinesToInclude");
    public static final IntegerSystemProperty FS_TIMESTAMP_RESOLUTION_MS = new IntegerSystemProperty(false, SystemProperty.getFilesystemTimestampResolution(), "bamboo.fs.timestamp.precision");
    public static final SystemProperty SEND_FILE_NAMES_TO_AGENT = new SystemProperty(false, "bamboo.send.file.names.to.agent");
    public static final SystemProperty ELASTIC_IMAGE_AMI_ID = new SystemProperty(false, "bamboo.aws.amiId");
    public static final IntegerSystemProperty MAXIMUM_ALLOWED_ELASTIC_AGENT_STARTUP_TIME_MINUTES = new IntegerSystemProperty(false, 55L, "bamboo.ec2.maximum.agent.startup.time");
    public static final BooleanSystemProperty EC2_HTTP_TUNNEL_ENABLED = new BooleanSystemProperty(false, true, "bamboo.ec2.tunnel.enabled");
    public static final BooleanSystemProperty EC2_JMS_TUNNEL_ENABLED = new BooleanSystemProperty(false, true, "bamboo.ec2.tunnel.jms.enabled");
    public static final IntegerSystemProperty EC2_TUNNEL_KEY_LENGTH = new IntegerSystemProperty(false, 2048L, "bamboo.ec2.tunnel.key.length");
    public static final SystemProperty EC2_IGNORE_CERT_CHECK = new SystemProperty(false, "bamboo.ec2.ignoreCertCheck");
    public static final SystemProperty FIRE_INITAL_BUILD_FOR_MANUAL_STRATEGY = new SystemProperty(false, "fire.initial.build.for.manual.strategy");
    public static final SystemProperty ALLOW_UNSUPPORTED_DB = new SystemProperty(false, "bamboo.enable.unsupported.db");
    public static final boolean PATH_SET_ALLOWED = new SystemProperty(false, "bamboo.paths.set.allowed").getValue(false);
    public static final SystemProperty BUILD_PARENT_JAVA_IO_TMPDIR = new SystemProperty(false, "bamboo.build.parent.java.io.tmpdir", "java.io.tmpdir");
    public static final SystemProperty EVENT_MANAGER_CORE_POOL_SIZE = new SystemProperty(false, "bamboo.event.bambooEventManager.corePoolSize");
    public static final SystemProperty EVENT_MANAGER_MAXIMUM_POOL_SIZE = new SystemProperty(false, "bamboo.event.bambooEventManager.maximumPoolSize");
    public static final SystemProperty HG_COMMAND_FORCE_DEBUG = new SystemProperty(false, "bamboo.hg.debug");
    public static final SystemProperty DIRECTORY_SCANNING_PLUGIN_SCAN_DIR = new SystemProperty(false, "atlassian.bamboo.plugin.scan.directory");
    public static final SystemProperty ELASTIC_AGENT_LOG_AWS_ID = new SystemProperty(false, "bamboo.ec2.agentLogAwsId");
    public static final SystemProperty ELASTIC_AGENT_LOG_AWS_SECRET = new SystemProperty(false, "bamboo.ec2.agentLogSecret");
    public static final SystemProperty BAMBOO_DELETION_ENABLED = new SystemProperty(false, "bamboo.deletion.enabled");
    public static final SystemProperty BAMBOO_RELOAD_AGENT_CLASSPATH = new SystemProperty(false, "bamboo.agent.reloadclasspath");
    public static final SystemProperty BAMBOO_MAX_AGENTS_LOADING = new SystemProperty(false, "bamboo.agent.max_loading");
    public static final SystemProperty BAMBOO_FREEMARKER_DEBUG = new SystemProperty(false, "bamboo.freemarker.debug");
    public static final SystemProperty MAX_VCS_OPERATION_RETRIES = new SystemProperty(false, "bamboo.vcs.retries");
    public static final SystemProperty PLAN_EXECUTION_DETECTION_THREADS = new SystemProperty(false, "bamboo.plan.exe.threads");
    public static final IntegerSystemProperty SPECS_DETECTION_THREADS = new IntegerSystemProperty(false, 4L, "bamboo.specs.detection.threads");
    public static final SystemProperty ARTIFACT_COMPRESSION_DARK_FEATURE = new SystemProperty(false, "bamboo.darkfeature.artifactcompression");
    public static final SystemProperty ROTP_DARK_FEATURE = new SystemProperty(false, "bamboo.darkfeature.rotp");
    public static final SystemProperty ROTP_PROJECT_SHORTCUTS_DARK_FEATURE = new SystemProperty(false, "atlassian.darkfeature.rotp.project.shortcuts");
    public static final SystemProperty ROTP_ADMIN_SHORTCUTS_DARK_FEATURE = new SystemProperty(false, "atlassian.darkfeature.rotp.admin.shortcuts");
    public static final SystemProperty PDL_DARK_FEATURE = new SystemProperty(false, "bamboo.darkfeature.pdl");
    public static final SystemProperty HG_CHANGE_SET_LIMIT = new SystemProperty(false, "HG_CHANGE_SET_LIMIT");
    public static final SystemProperty ARTIFACT_SIZE_LIMIT_PER_BUILD = new SystemProperty(false, "bamboo.artifact.size.limit.per.build");
    public static final SystemProperty DISABLE_BRANCH_DETECTION = new SystemProperty(false, "atlassian.bamboo.branch.detection.disable");
    public static final BooleanSystemProperty DISABLE_TAG_DETECTION = new BooleanSystemProperty(false, false, "atlassian.bamboo.tag.detection.disable");
    public static final SystemProperty DISABLE_CLOSED_BRANCH_DETECTION = new SystemProperty(false, "atlassian.bamboo.closed.branch.detection.disable");
    public static final SystemProperty ATLASSIAN_DEV_MODE = new SystemProperty(false, "atlassian.dev.mode");
    public static final SystemProperty BAMBOO_REQUEST_PROFILING = new SystemProperty(false, "bamboo.request.profiling");
    public static final BooleanSystemProperty ALLOW_MUTATIVE_GET_IN_STRICT_XSRF_MODE = new BooleanSystemProperty(false, false, "bamboo.allowMutativeGetInStrictXsrfMode");
    public static final BooleanSystemProperty BAMBOO_MANAGED_JMS_SSL = new BooleanSystemProperty(false, false, "bamboo.manage.jms.ssl");
    public static final IntegerSystemProperty EXPORT_WAIT_FOR_SERVER_PAUSE_SLEEP = new IntegerSystemProperty(false, Duration.ofMinutes(1L).toMillis(), "bamboo.export.wait.for.server.pause.sleep");
    public static final IntegerSystemProperty EXPORT_WAIT_FOR_SERVER_PAUSE_TIMEOUT = new IntegerSystemProperty(false, Duration.ofHours(1L).toMillis(), "bamboo.export.wait.for.server.pause.timeout");
    public static final SystemProperty EC2_AGENT_ENDPOINT = new SystemProperty(false, "bamboo.ec2.agent.endpoint");
    public static final SystemProperty CUSTOM_S3_ASSEMBLY_BUCKET = new SystemProperty(false, "bamboo.s3.agent.bucket");
    public static final SystemProperty FILE_UPLOAD_MAXIMUM_SIZE = new SystemProperty(false, "bamboo.file.upload.max.size");
    public static BooleanSystemProperty FUSION_DEPLOYMENTS_SUPPORT_DISABLED = new BooleanSystemProperty(false, false, "bamboo.fusion.deployments.support.disabled");
    public static final IntegerSystemProperty STASH_SSH_PORT_NUMBER = new IntegerSystemProperty(false, 7999L, "bamboo.stash.port.number");
    public static BooleanSystemProperty REMOVE_LABELS_AND_PLANS_FOR_NON_PLAN_ADMIN = new BooleanSystemProperty(false, false, "bamboo.remove.labels.by.non.plan.admin");
    public static BooleanSystemProperty DISABLE_STASH_BUILD_STATUS_UPDATES = new BooleanSystemProperty(false, false, "bamboo.stash.disable.build.status.updates");
    public static BooleanSystemProperty DISABLE_STASH_EXTENDED_BUILD_STATUS_UPDATES = new BooleanSystemProperty(false, false, "bamboo.stash.disable.extended.build.status.updates");
    public static BooleanSystemProperty ENFORCE_POLLING_BRANCH_DETECTION_EVEN_WHEN_REPO_CAN_PUSH_IT = new BooleanSystemProperty(false, false, "bamboo.stash.enforce.polling.branches");
    public static IntegerSystemProperty STASH_REPOSITORY_TRIGGER_POLLING_INTERVAL = new IntegerSystemProperty(false, 0L, "bamboo.stash.repository.trigger.polling.interval");
    public static final BooleanSystemProperty AGENT_QUEUE_OFFLOADING_ENABLED = new BooleanSystemProperty(false, false, "bamboo.agent.queue.offloading.enabled");
    public static BooleanSystemProperty ENABLE_REMOTE_AGENTS_SHELL = new BooleanSystemProperty(false, false, "bamboo.enable.remote.agent.shell");
    public static final BooleanSystemProperty LIMITED_TIME_QUARANTINE_ENABLED = new BooleanSystemProperty(false, false, "bamboo.darkfeature.limited.time.quarantine");
    public static BooleanSystemProperty SKIP_BOOT_DELEGATION_OVERRIDES = new BooleanSystemProperty(false, false, "bamboo.skip.boot.delegation.override");
    public static BooleanSystemProperty ENABLE_XML_FACTORY_OVERRIDE = new BooleanSystemProperty(false, false, "bamboo.enable.xml.factory.override");
    public static final IntegerSystemProperty MAX_CONCURRENT_EXPENSIVE_MESSAGES = new IntegerSystemProperty(false, 1L, "bamboo.max.concurrent.expensive.messages");
    public static final SystemProperty BRANCH_EXPIRY_SCHEDULED_TIME = new SystemProperty(false, "bamboo.branch.expiry.schedule");
    public static final BooleanSystemProperty PERSIST_RUNTIME_STATE = new BooleanSystemProperty(false, false, "bamboo.darkfeature.persist.runtime.state");
    public static final BooleanSystemProperty BAMBOO_IGNORE_SERVER_STATE_ON_RESTART = new BooleanSystemProperty(false, false, "bamboo.ignore.server.state.on.restart");
    public static final BooleanSystemProperty GLOBAL_REPOSITORY_DASHBOARD = new BooleanSystemProperty(false, false, "bamboo.darkfeature.repository.dashboard");
    public static final BooleanSystemProperty DISABLE_MAIN_DASHBOARD_OPTIMIZATION = new BooleanSystemProperty(false, false, "bamboo.dashboard.disable.optimization");
    public static final IntegerSystemProperty MAIL_QUEUE_SIZE = new IntegerSystemProperty(false, 1000L, "bamboo.mail.queue.size");
    public static final SystemProperty GRAVATAR_BASE_URL = new SystemProperty(false, "aid.avatar.url");
    public static final SystemProperty PLAN_DIRECTORY_INFO_REST = new SystemProperty(false, "bamboo.plan.directory.info.rest");
    public static final SystemProperty BAMBOO_INSTANCE_SPECIFIC_DATA_LOCATIONS = new SystemProperty(false, "bamboo.instance.specific.data.locations");
    public static final BooleanSystemProperty GIT_PASSWORD_USE_CREDENTIALS_FILE = new BooleanSystemProperty(false, true, "bamboo.git.password.use.credentials.file");
    public static final SystemProperty ELASTIC_AGENT_INSTANCE_NAME = new SystemProperty(false, "elastic.agent.instance.name");
    public static final BooleanSystemProperty CRYPTO_TRUST_HG_SSH_ALL = new BooleanSystemProperty(false, false, "bamboo.crypto.trust.hg.ssh.all");
    public static final BooleanSystemProperty CRYPTO_TRUST_SVN_SSH_ALL = new BooleanSystemProperty(false, false, "bamboo.crypto.trust.svn.ssh.all");
    public static final BooleanSystemProperty DISABLE_SERIALIZATION_SECURITY = new BooleanSystemProperty(false, false, "bamboo.security.serialization.disable");
    public static final IntegerSystemProperty MAX_PENDING_TEST_CASE_EVICTIONS = new IntegerSystemProperty(false, 1000L, "bamboo.max.pending.test.case.evictions");
    public static final SystemProperty ORPHANED_TEST_CASE_CRON_SCHEDULE = new SystemProperty(false, "bamboo.orphaned.test.case.cron");
    public static final BooleanSystemProperty SKIP_MSSQL_CONFIG_VALIDATION = new BooleanSystemProperty(false, false, "bamboo.skip.mssql.config.validation");
    public static final BooleanSystemProperty HIDE_PORTED_LEGACY_REPOSITORIES = new BooleanSystemProperty(false, true, "hide.ported.legacy.repositories");
    public static final BooleanSystemProperty DISABLE_ALL_DARK_FEATURES = new BooleanSystemProperty(false, false, "atlassian.darkfeature.disabled");
    public static final BooleanSystemProperty ALLOW_URL_PARAMETERS_LOGIN = new BooleanSystemProperty(false, false, "bamboo.allow.url.parameters.login");
    public static final BooleanSystemProperty DISABLE_ENCRYPTION = new BooleanSystemProperty(false, false, "bamboo.security.encryption.disable");
    public static final BooleanSystemProperty IGNORE_DECRYPTION_ERRORS = new BooleanSystemProperty(false, false, "bamboo.security.decryption.ignore.errors");
    public static final IntegerSystemProperty REPOSITORY_STORED_SPECS_TIMEOUT_SECONDS = new IntegerSystemProperty(false, 60L, "bamboo.repository.stored.specs.timeout_seconds");
    public static final IntegerSystemProperty REPOSITORY_STORED_SPECS_THREADS = new IntegerSystemProperty(false, 3L, "bamboo.repository.stored.specs.threads");
    public static final BooleanSystemProperty REPOSITORY_STORED_SPECS_SECURITY_MANAGER_ENABLED = new BooleanSystemProperty(false, true, "bamboo.repository.stored.specs.security.manager.enabled");
    public static final BooleanSystemProperty REPOSITORY_STORED_SPECS_POM_SANITIZATION_ENABLED = new BooleanSystemProperty(false, true, "bamboo.repository.stored.specs.pom.sanitization.enabled");
    public static final IntegerSystemProperty CHANGE_DETECTION_CACHE_TTL_SECONDS = new IntegerSystemProperty(false, 15L, "bamboo.change.detection.cache.ttl.seconds");
    public static final IntegerSystemProperty PULL_REQUEST_DETECTION_THREAD_COUNT = new IntegerSystemProperty(false, 3L, "bamboo.pull.request.detection.threads.count");
    public static final SystemProperty ORPHANED_PULL_REQUESTS_CLEANUP_SCHEDULE = new SystemProperty(false, "bamboo.pull.request.orphaned.cleanup.cron");
    public static final IntegerSystemProperty ORPHANED_PULL_REQUEST_INACTIVITY_DAYS = new IntegerSystemProperty(false, 7L, "bamboo.pull.request.orphaned.cleanup.inactivity.days");
    public static final IntegerSystemProperty PULL_REQUEST_POLLING_INTERVAL = new IntegerSystemProperty(false, 0L, "bamboo.pull.request.polling.interval.seconds");
    public static final IntegerSystemProperty PULL_REQUEST_CACHE_TTL = new IntegerSystemProperty(false, 60L, "bamboo.pull.request.cache.ttl.seconds");
    public static final BooleanSystemProperty JUNIT_PARSER_IGNORE_NAMED_INNER_CLASSES = new BooleanSystemProperty(false, false, "bamboo.junit.parser.ignore.named.inner.classes");
    public static final IntegerSystemProperty DEFAULT_TIMEOUT_FOR_HTTP_CLIENT = new IntegerSystemProperty(false, 5000L, "bamboo.rest.utils.defaultTimeout");
    public static final BooleanSystemProperty DISABLE_X_CONTENT_TYPE_OPTIONS_NOSNIFF = new BooleanSystemProperty(false, false, "bamboo.security.x.content.type.options.nosniff.disable");
    public static final SystemProperty TEXT_PLAIN_MIME_DEFAULT_ENCODING = new SystemProperty(false, "bamboo.text.plain.mime.encoding");
    public static final BooleanSystemProperty CHECK_MYSQL_VER_ON_UPGRADE = new BooleanSystemProperty(false, true, "bamboo.upgrade.fail.if.mysql.unsupported");
    public static final BooleanSystemProperty CHECK_JAVA_VERSION_ON_UPGRADE = new BooleanSystemProperty(false, true, "bamboo.upgrade.fail.if.java.unsupported");
    public static final BooleanSystemProperty SETUP_RSS_IN_DOCKER = new BooleanSystemProperty(false, true, "bamboo.setup.rss.in.docker");
    public static final BooleanSystemProperty SKIP_RSS_OPTIMISATION = new BooleanSystemProperty(false, false, "bamboo.rss.skip.optimisation");
    public static final BooleanSystemProperty DOCKER_PIPELINES_DISABLED = new BooleanSystemProperty(false, false, "bamboo.docker.pipelines.disable");
    public static final BooleanSystemProperty RSS_COMMIT_LEVEL_COMMENT_DISABLED = new BooleanSystemProperty(false, false, "bamboo.repository.stored.specs.commit.comment.disabled");
    public static final BooleanSystemProperty LOGS_AS_ARTIFACTS_ENABLED = new BooleanSystemProperty(false, true, "bamboo.logs.as.artifacts");
    public static final SystemProperty VARIABLE_UPGRADE_SCHEDULE_CRON = new SystemProperty(false, "bamboo.variable.upgrade.schedule");
    public static final int VARIABLE_UPGRADE_DEFAULT_BATCH_SIZE = 300;
    public static final IntegerSystemProperty VARIABLE_UPGRADE_BATCH_SIZE = new IntegerSystemProperty(false, 300L, "bamboo.variable.upgrade.batch.size");
    public static final IntegerSystemProperty BUILD_WARNINGS_MAXIMUM_COUNT_PER_BUILD = new IntegerSystemProperty(false, -1L, "bamboo.build.warnings.maximum.count");
    public static final IntegerSystemProperty BUILD_WARNINGS_THREAD_COUNT = new IntegerSystemProperty(false, 2L, "bamboo.build.warnings.thread.count");
    public static final IntegerSystemProperty BUILD_WARNINGS_QUEUE_MAX_SIZE = new IntegerSystemProperty(false, 200L, "bamboo.build.warnings.queue.max.size");
    public static final BooleanSystemProperty RSS_POLLING_ENABLED = new BooleanSystemProperty(false, false, "bamboo.rss.polling.enabled");
    public static final IntegerSystemProperty CROWD_DELETED_ENTITY_LISTENER_THREADS = new IntegerSystemProperty(false, 2L, "bamboo.crowd.deleted.entity.listener.threads");
    public static final IntegerSystemProperty CROWD_DELETED_ENTITY_TIMEOUT_DAYS = new IntegerSystemProperty(false, 7L, "bamboo.crowd.deleted.entity.timeout.days");
    public static final IntegerSystemProperty CROWD_DELETED_ENTITY_CLEANUP_HOUR = new IntegerSystemProperty(false, 4L, "bamboo.crowd.deleted.entity.cleanup.hour");
    public static final BooleanSystemProperty PERFORMANCE_DATA_GATHERING_ENABLED = new BooleanSystemProperty(false, true, "bamboo.performance.data.gathering.enabled");
    public static final BooleanSystemProperty PERFORMANCE_DATA_TEST_GATHERING_ENABLED = new BooleanSystemProperty(false, false, "bamboo.test.performance.data.gathering.enabled");
    public static final IntegerSystemProperty PERFORMANCE_DATA_DISPATCH_HOUR = new IntegerSystemProperty(false, 2L, "bamboo.performance.data.dispatch.hour");
    public static final BooleanSystemProperty EC_UPGRADE_TEST_CONNECTION_ENABLED = new BooleanSystemProperty(false, true, "bamboo.ec.upgrade.test.connection.enabled");
    public static final BooleanSystemProperty DISABLE_REMOTE_TRIGGER_PROXY_VALIDATION = new BooleanSystemProperty(false, false, "bamboo.remote.trigger.proxy.validation.disabled");
    public static final IntegerSystemProperty SPECS_YAML_INCLUDE_MAX_DEPTH = new IntegerSystemProperty(false, 10L, "bamboo.specs.yaml.include.max.depth");
    public static final SystemProperty JMS_STORE_DIRECTORY = new SystemProperty(false, "bamboo.jms.store.directory");
    public static final IntegerSystemProperty MAX_TOKENS_PER_USER = new IntegerSystemProperty(false, 100L, "bamboo.access.token.user.max");
    public static final BooleanSystemProperty DISABLE_RESULTS_CLEANUP_ON_STARTUP = new BooleanSystemProperty(false, false, "bamboo.disable.results.cleanup.on.startup");
    public static final BooleanSystemProperty DEFER_RESULTS_CLEANUP_ON_STARTUP = new BooleanSystemProperty(false, false, "bamboo.defer.results.cleanup.on.startup");
    public static final BooleanSystemProperty SPECS_FOR_BRANCHES_ENABLED = new BooleanSystemProperty(false, true, "bamboo.specs.for.branches.enabled");
    public static final BooleanSystemProperty NOTIFICATION_DISABLED = new BooleanSystemProperty(false, false, "atlassian.mail.senddisabled");
    public static final BooleanSystemProperty SHOW_STACK_TRACES_ON_500 = new BooleanSystemProperty(false, true, "bamboo.show.internal.server.error.stacks");
    public static final IntegerSystemProperty OSGI_SERVICE_INVOCATION_TIMEOUT = new IntegerSystemProperty(false, 10000L, "bamboo.osgi.service.invocation.timeout");
    public static final SystemProperty ORPHANED_SPECS_STATES_CLEANUP_SCHEDULE = new SystemProperty(false, "bamboo.orphaned.specs.states.cleanup.cron");
    public static final IntegerSystemProperty SPECS_MAX_ALIASES_FOR_COLLECTIONS = new IntegerSystemProperty(false, 1500L, "bamboo.specs.max.aliases.for.collections");
    public static final BooleanSystemProperty GLOBAL_EXPORT_TO_SPECS_ENABLED = new BooleanSystemProperty(false, false, "global.export.to.specs.enabled");
    public static final BooleanSystemProperty NATIVE_GIT_FOLDER_CLEARING_DISABLED = new BooleanSystemProperty(false, false, "bamboo.native.git.folder.clearing.disabled");
    public static final IntegerSystemProperty WEBHOOK_MAX_QUEUE_SIZE = new IntegerSystemProperty(false, 1024L, "bamboo.webhook.queue.size");
    public static final IntegerSystemProperty WEBHOOK_TIMEOUT = new IntegerSystemProperty(false, 10000L, "bamboo.webhook.timeout");
    public static final IntegerSystemProperty WEBHOOK_MAX_RETRIES = new IntegerSystemProperty(false, 3L, "bamboo.webhook.max.retries");
    public static final IntegerSystemProperty WEBHOOK_THREAD_COUNT = new IntegerSystemProperty(false, 2L, "bamboo.webhook.threads.count");
    public static final BooleanSystemProperty PROJECT_LEVEL_BUILD_RESOURCES_ENABLED = new BooleanSystemProperty(false, false, "bamboo.project.build.resources.enabled");
    public static final IntegerSystemProperty REMOTE_BROADCAST_DOWNTIME_INCREMENT_SECONDS = new IntegerSystemProperty(false, 30L, "bamboo.remote.broadcast.downtime.increment.second");
    public static final IntegerSystemProperty REMOTE_BROADCAST_DOWNTIME_MAX_MULTIPLIER = new IntegerSystemProperty(false, 5L, "bamboo.remote.broadcast.downtime.max.multiplier");
    public static final IntegerSystemProperty REMOTE_AGENT_ASYNCH_DISPATCH_THREADPOOL_SIZE = new IntegerSystemProperty(false, 0L, "bamboo.remote.asynch.dispatch.threadpool.size");
    public static final IntegerSystemProperty IMPORT_REPORT_PROGRESS_STEP_PROPERTY = new IntegerSystemProperty(false, 1000L, "bamboo.import.display.progress.step");

    public SystemProperty(boolean mandatory, String ... properties) {
        super(mandatory, properties);
    }

    @VisibleForTesting
    protected SystemProperty(String property, boolean mandatory, Logger log) {
        super(property, mandatory, log);
    }

    private static int getFilesystemTimestampResolution() {
        return SystemUtils.IS_OS_MAC ? 1000 : 100;
    }

    public static class UrlSystemProperty
    extends AbstractSystemProperty {
        public UrlSystemProperty(boolean mandatory, String ... properties) {
            super(mandatory, properties);
        }

        @Override
        @NotNull
        public String getValue(@NotNull String defaultValue) {
            return UrlUtils.correctlyFormatUrl(super.getValue(defaultValue));
        }
    }

    public static class BooleanSystemProperty
    extends AbstractSystemProperty {
        private final boolean defaultValue;

        public BooleanSystemProperty(boolean mandatory, boolean defaultValue, String ... properties) {
            super(mandatory, properties);
            this.defaultValue = defaultValue;
        }

        public boolean getTypedValue() {
            String stringValue = this.getValue();
            if (stringValue == null) {
                return this.defaultValue;
            }
            return BooleanUtils.toBoolean((String)stringValue);
        }

        public void setTypedValue(boolean value) {
            this.setValue(Boolean.toString(value));
        }
    }

    public static class IntegerSystemProperty
    extends AbstractSystemProperty {
        private final long defaultValue;

        public IntegerSystemProperty(boolean mandatory, long defaultValue, String ... properties) {
            super(mandatory, properties);
            this.defaultValue = defaultValue;
        }

        public long getTypedValue() {
            String stringValue = this.getValue();
            if (stringValue == null) {
                return this.defaultValue;
            }
            return Long.parseLong(stringValue);
        }
    }
}

